@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Create Zoom Hardware API Credentials', 'parentTitle'=>'Settings','parentUrl'=>'/settings'])

<div class="wrapper wrapper-content">
    <div class="container-fluid">
    	<div class="row">

	        <div class="col-lg-12">
				<form class="form-horizontal" method="post" action="{{route('zoom-hardware.store')}}">
					<div class="ibox">
	                	<div class="ibox-content">
	                		@include('partials.error')
				    		{{csrf_field()}}
							<div class="form-group">
								<label class="col-lg-3 control-label">Account ID <span class="text-danger">*</span> </label>
								<div class="col-lg-6">
									<input type="text" class="form-control" name="app_name" value="{{ old('app_name') }}" required>
								</div>
							</div>

		                    <div class="form-group">
		                        <label class="col-lg-3 control-label">Client ID <span class="text-danger">*</span></label>
		                        <div class="col-lg-6">
		                            <input type="text" class="form-control" name="client_id" value="{{ old('client_id') }}" required>
		                        </div>
		                    </div>

							<div  class="form-group">
								<label class="col-lg-3 control-label">Client Secret <span class="text-danger">*</span></label>
		                        <div class="col-lg-6">
		                            <input type="password" class="form-control" name="client_secret" value="" required>
		                        </div>
							</div>

		                    <div class="form-group">
								<div class="col-lg-offset-3 col-lg-1">
									<button class="btn btn-success" name="commit" type="submit">Save</button>
								</div>
							</div>

						</div>
					</div>
				</form>
		    </div>
		</div>
	</div>
</div>
@stop

@section('after_scripts')
    @include('assets.partials.scripts.common')
@stop