@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Zendesk API Credential','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="ibox">
            
            <div class="ibox-content">
                
                <!-- <p><a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html" data-target="#addApiCredential">Add New</a></p> -->
                @include('partials.error-message')
                @include('partials.success')
                
                @include('settings.partials.delete-message')
                
                <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                id="api-credential-table">
                
                <thead>
                    
                    <tr>
                        <th>Name</th>
                        <th>Status</th>
                        <th>URL</th>
                        <th>Edit</th>
                    </tr>
                    
                </thead>
                
                <tbody>
                    
                    @if($apiCredential)
                    <tr>
                        <td>{{$apiCredential->api_name}}</td>
                        <td>
                            @if ($status == 0)
                            <a href="javascript:;" class="btn btn-danger btn-sm">Inactive</a>
                            @else
                            <a href="#" class="btn btn-primary btn-sm" disabled>Active</a>
                            @endif
                        </td>
                        <td>{{$apiCredential->url}}</td>
                        <td>@can('API Credentials Edit')<a
                            href="{{route('zendesk.edit', ['zendesk' => $apiCredential->id])}}"><i
                            class="icon icon-n-edit"></i></a>@endcan</td>
                        </tr>
                        @else
                        <tr>
                            <td colspan="7">No Api Credentials in the system.</td>
                        </tr>
                        @endif
                        
                    </tbody>
                    
                    <tfoot>
                        
                        <tr>
                            
                            <td colspan="4">
                                
                                <ul class="pagination pull-right"></ul>
                                
                            </td>
                            
                        </tr>
                        
                    </tfoot>
                    
                </table>
                
            </div>
            
        </div>
        
    </div>
    
</div>


@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection


@section('after_scripts')
@include('settings.partials.responsive-fixedheader')
@stop