@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Create Zendesk API
Credential','parentTitle'=>'Settings','parentUrl'=>'/settings','parentSubTitle' => 'Zendesk API Credential','parentSubUrl'=>'/zendesk'])

<div class="wrapper-content">
	<div class="container-fluid">
		<div class="ibox">
			@include('partials.error')
			<div class="ibox-content">
				<form class="form-horizontal" method="post"
					action="{{route('zendesk.store')}}">
					{{csrf_field()}}

					<div class="form-group">
						<label class="col-lg-3 control-label">URL<span class="text-danger">*</span></label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="url" value="{{ old('url') }}">
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">API Key<span class="text-danger">*</span></label>
						<div class="col-lg-6">
							<input type="password" class="form-control" name="key"
								value="">
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">User Email<span class="text-danger">*</span></label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="user_name"
								value="{{old('user_name')}}">
						</div>
					</div>

					<div class="form-group">
						<div class="col-lg-offset-3 col-lg-1">
							<button class="btn btn-primary" name="commit" type="submit">Save</button>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection


@section('after_scripts')
@include('assets.partials.scripts.common')
@stop