<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<script src="/js/plugins/dataTables/dataTables.fixedHeader.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<link rel="stylesheet" href="/css/plugins/dataTables/responsive.dataTables.min.css">
<script src="/js/plugins/dataTables/dataTables.responsive.min.js"></script>
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/sweetalert2.all.min.js"></script>
<script>

    $(document).ready(function() {
        $('.chosen-select').chosen({width: "100%"}).change(function() {
            $(this).closest('.form-group').next().find('input').focus();
        });

        $('.modal').on('show.bs.modal', function (e) {
            $(".alert-danger").hide();
            $("label.error").hide();
            $(".form-control").removeClass("error");
        });

        $.fn.serializeObject = function(){
           var obj = {};

           $.each( this.serializeArray(), function(i,o){
              var n = o.name, v = o.value;

              obj[n] = obj[n] === undefined ? v
                 : $.isArray( obj[n] ) ? obj[n].concat( v )
                 : [ obj[n], v ];
           });

           return obj;
        };

        var table = $('.footable').DataTable({
            responsive: true,
            scrollCollapse: false,
            scrollX: false,
            scrollY: false,
            "processing": true,
            "serverSide": true,
            paging: true,
            "pageLength": 50,
            lengthMenu: [
                [ 50, 100, 200],
                [ '50', '100', '200']
            ],
            columnDefs: [
               { orderable: false, targets: '_all' },
            ],
            "aaSorting": [],
            "bFilter": true,
            "bLengthChange": false,
            "searching": false,
            fixedHeader: {
                header: true,
            },

            "ajax":{
                "url": "{{ route('vendor-data') }}",
                "dataType": "json",
                "type": "POST",
                "data": function( result ) {
                    result.form = $('#search-form').serializeObject();
                }
            },
            "columns": [
                { "data": "id" },
                { "data": "name" },
                { "data": "action" }
            ]
        });

        var delay = (function(){
          var timer = 0;
          return function(callback, ms){
            clearTimeout (timer);
            timer = setTimeout(callback, ms);
          };
        })();

        $('#search-form').submit(function (e) {
            e.preventDefault();
            table.draw();
        });

        $("#vendor").on('change', function(){
            $('#search-form').submit();
        });

        $("#searchText").on('keyup change', function(){
            delay(function(){
                $('#search-form').submit();
            }, 200 );
        });

        $('#export-csv').on('click', function(e) {
	        e.preventDefault();
	        $('.ajax-loader').show();
	        $.ajax({
	            type: "POST",
	            url: "/location/location-export",
	            data: $('#search-form').serializeObject(),
	            dataType: 'text',
	            success: function(result) {
	                var blob = new Blob([result]);
	                if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
	                    window.navigator.msSaveBlob(blob, "locations.csv");
	                else
	                {
	                    var a = window.document.createElement("a");
	                    a.href = window.URL.createObjectURL(blob, {type: "text/plain"});
	                    a.download = "locations.csv";
	                    document.body.appendChild(a);
	                    a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
	                    document.body.removeChild(a);
	                }
	                $('.ajax-loader').hide();
	            }
	        })
	    });

        $('#add').on('click', function (e) {
            e.preventDefault();
            $(".sync-msg").hide();
            $("#nameError").text('');
            if($('#add-vendor-form').valid()) {
                var formData = $('#add-vendor-form').serialize();
                $.ajax({
                    type: "POST",
                    url: "/add-vendor",
                    data: formData ,
                    success: function(value) {
                        $('#addVendorModal').modal('hide');
                        $('#add-vendor-form')[0].reset();
                        $('#sync-success').show();
                        $('#sync-success-msg').text("Vendor added successfully.");
                        table.draw();
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        var errors = JSON.parse(xhr.responseText);
                        $("#nameError").text(errors.errors.name);
                    }
                });
            }
        });

        $('#edit').on('click', function (e) {
            e.preventDefault();
            $(".sync-msg").hide();
            $(".vendor-error").text('');
            if($('#edit-vendor-form').valid()) {
                var formData = $('#edit-vendor-form').serialize();
                $.ajax({
                    type: "POST",
                    url: "/update-vendor",
                    data: formData ,
                    success: function(value) {
                        $('#editVendorModal').modal('hide');
                        $('#edit-vendor-form')[0].reset();
                        $('#sync-success').show();
                        $('#sync-success-msg').text("Vendor updated successfully.");
                        table.draw();
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        var errors = JSON.parse(xhr.responseText);
                        $("#updateNameError").text(errors.errors.name);
                    }
                });
            }
        });


        $(window).keydown(function(event){
            if(event.keyCode == 13) {
                if($('#addVendorModal').is(':visible')){
                    event.preventDefault();
                    $('#add').click();
                }
                else if($('#editVendorModal').is(':visible')){
                    event.preventDefault();
                    $('#edit').click();
                }
            }
        });

        $(document).on('click','.remove', function (e) {
            e.preventDefault();
            $(".sync-msg").hide();
            Swal.fire({
                title: 'Do you want to remove the vendor?',
                icon: 'warning',
                allowOutsideClick: false,
                showCancelButton: true,
                confirmButtonText: 'Remove',
                }).then((result) => {

                if (result.isConfirmed) {
                    $.ajax({
                        type: "POST",
                        url: "/remove-vendor",
                        data: { id: $(this).data('vendor-id') },
                        success: function(value) {
                            $('#sync-success').show();
                            $('#sync-success-msg').text("Vendor removed successfully.");
                            table.draw();
                        }
                    });
                }
            })
        });


        $('#editVendorModal').on('show.bs.modal', function (e) {
            var id = $(e.relatedTarget).data('vendor-id');
            $(".vendor-error").text('');
            $.ajax({
                    type: "POST",
                    url: "/edit-vendor/"+id,
                    dataType: 'json',
                    success: function(value) {
                        const $categories = $('#vendor-categories-edit');
                        $('#edit-id').val(value['id']);
                        $('#edit-name').val(value['name']);
                        $categories.val(value['selectedCategories']).trigger("chosen:updated");
                    }
                });
        });

        $('.filter-vendor').each(function () {
            $(this).ajaxChosen({
                dataType: 'json',
            }, {
                processItems: function (data) { return data },
                generateUrl: function (q) { return '/get-filter-vendor?search=' + q; },
            },
            {
                    width: "100%"
            });
        });

    });

</script>