<div class="modal inmodal" id="editVendorModal" tabindex="-1" role="dialog">

    <div class="modal-dialog">

        <div class="modal-content animated fadeIn">

            <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal"><span>×</span><span class="sr-only">Close</span></button>

                <h4 class="modal-title">Edit Vendor</h4>

            </div>

            <div class="modal-body">

                @include('partials.error')

                <form class="form-horizontal" action="" method="post" id="edit-vendor-form">

                    {{csrf_field()}}
                    <input type="hidden" class="form-control " name="id" id="edit-id" value="{{old('id')}}" required>
                    <div class="form-group">

                        <label class="col-lg-2 control-label">Vendor</label>

                        <div class="col-lg-10">

                            <input type="text" class="form-control vendor" name="name" id="edit-name" value="{{old('name')}}" required>
                            <span class="text-danger vendor-error" id="updateNameError"></span>

                        </div>



                    </div>

                    <div class="form-group">
                        <label class="col-lg-2 control-label">Categories</label>
                        <div class="col-lg-10">
                        <select id="vendor-categories-edit" name="categories[]" placeholder="Select" class="form-control chosen-select" multiple="multiple">
                            @foreach(\App\Models\VendorCategory::orderBy('slug')->get() as $category)
                                <option value="{{$category->id}}">{{$category->name}}</option>
                            @endforeach
                            </select>
                            <span class="text-danger" id="updateCategoriesError"></span>
                        </div>
                    </div>

                </form>

            </div>

            <div class="modal-footer">

                <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>

                <button type="button" class="btn btn-primary" id="edit">Save</button>

            </div>

        </div>

    </div>

</div>