<div class="modal inmodal" id="addVendorModal" tabindex="-1" role="dialog">

    <div class="modal-dialog">

        <div class="modal-content animated fadeIn">

            <div class="modal-header">

                <button type="button" class="close" data-dismiss="modal"><span>×</span><span class="sr-only">Close</span></button>

                <h4 class="modal-title">Add New Vendor</h4>

            </div>

            <div class="modal-body">

                @include('partials.error')

                <form class="form-horizontal" action="" method="post" id="add-vendor-form">

                    {{csrf_field()}}

                    <div class="form-group">

                        <label class="col-lg-2 control-label">Vendor</label>

                        <div class="col-lg-10">

                            <input type="text" class="form-control vendor" name="name" value="{{old('name')}}" required>
                            <span class="text-danger vendor-error" id="nameError"></span>

                        </div>

                    </div>

                    <div class="form-group">
                        <label class="col-lg-2 control-label">Categories</label>
                        <div class="col-lg-10">
                        <select id="vendor-categories" name="categories[]"  data-placeholder="Select"  class="form-control chosen-select" multiple="multiple">
                        
                            @foreach(\App\Models\VendorCategory::orderBy('slug')->get() as $category)
                                <option value="{{$category->id}}">{{$category->name}}</option>
                            @endforeach

                        </select>
                            <span class="text-danger" id="updateCategoriesError"></span>
                        </div>
                    </div>

                    

                </form>

            </div>

            <div class="modal-footer">

                <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>

                <button type="button" class="btn btn-primary" id="add">Save</button>

            </div>

        </div>

    </div>

</div>