<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script>
    $(document).ready(function() {
        $('.chosen-select').chosen({
            width: "100%"
        }).change(function() {
            $(this).closest('.form-group').next().find('input').focus();
        });

        $('#add').on('click', function(e) {
            e.preventDefault();
            $(".sync-msg").hide();
            $("#nameError").text('');
            if ($('#add-category-form').valid()) {
                var formData = $('#add-category-form').serialize();
                $.ajax({
                    type: "POST",
                    url: "/vendor-categories",
                    data: formData,
                    success: function(value) {
                        $('#addCategoryModal').modal('hide');
                        $('#add-category-form')[0].reset();
                        $('#sync-success').show();
                        $('#sync-success-msg').text("Vendor category added successfully.");
                        $('#search-form').submit();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        var errors = JSON.parse(xhr.responseText);
                        $("#nameError").text(errors.errors.name);
                    }
                });
            }
        });


        $('#edit').on('click', function(e) {
            e.preventDefault();
            $(".sync-msg").hide();
            $(".category-error").text('');

            if ($('#edit-category-form').valid()) {
                var formData = $('#edit-category-form').serialize() + "&_method=PUT"; 
                var categoryId = $('#edit-id').val();

                $.ajax({
                    type: "POST", 
                    url: "/vendor-categories/" + categoryId, 
                    data: formData,
                    success: function(value) {
                        $('#editCategoryModal').modal('hide');
                        $('#edit-category-form')[0].reset();
                        $('#sync-success').show();
                        $('#sync-success-msg').text("Vendor category updated successfully.");
                        $('#search-form').submit();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        var errors = JSON.parse(xhr.responseText);
                        $("#updateNameError").text(errors.errors.name);
                    }
                });
            }
        });


        $(window).keydown(function(event) {
            if (event.keyCode == 13) {
                if ($('#addCategoryModal').is(':visible')) {
                    event.preventDefault();
                    $('#add').click();
                } else if ($('#editCategoryModal').is(':visible')) {
                    event.preventDefault();
                    $('#edit').click();
                }
            }
        });

        $(document).on('click', '.remove', function(e) {
            var id = $(this).attr('data-category-id');
            var name = $(this).attr('data-category-name');
            $('#confirm-delete').modal('show');
            $('#confirm-delete').attr('data-form', $(this).attr('data-category-id'));

            $('#confirm-message').html('Are you sure you want to delete vendor category ' + name + ' ? ');
        });

        $(".confirm-delete-button").on("click", function() {
            let categoryId = $('#confirm-delete').attr('data-form');

            $.ajax({
                type: "DELETE",
                url: "/vendor-categories/" + categoryId,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') 
                },
                success: function(data) {
                    if (data !== 'Success') {
                        $('#error').show();
                        $('#error p').text(data);
                        $('html, body').animate({
                            scrollTop: $("#error").offset().top
                        }, 3000);
                    } else {
                        $('#sync-success').show();
                        $('#sync-success-msg').text("Vendor category removed successfully.");
                        $('html, body').animate({
                            scrollTop: $("#sync-success").offset().top
                        }, 1000);
                        $('#search-form').submit();
                    }
                    $('.ajax-loader').hide();
                },
                error: function(xhr) {
                    $('#error').show();
                    $('#error p').text(xhr.responseText || "An error occurred.");
                    $('html, body').animate({
                        scrollTop: $("#error").offset().top
                    }, 3000);
                }
            });

            $('#confirm-delete').modal('hide');
        });

        $('#editCategoryModal').on('show.bs.modal', function(e) {
            var id = $(e.relatedTarget).data('category-id');
            $(".category-error").text('');
            $.ajax({
                type: "GET",
                url: "/vendor-category/" + id,
                dataType: 'json',
                success: function(value) {
                    $('#edit-id').val(value['id']);
                    $('#edit-name').val(value['name']);
                }
            });
        });

    });
</script>