@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Vendor Categories','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        @include('settings.vendor-categories.filter-categories')
        <div class="ibox">
            <div class="ibox-content">

                @include('partials.sync-messages')
                <p class='pull-right'>
                    <a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html" data-target="#addCategoryModal">Add New</a>
                </p>
                @include('settings.partials.delete-message')
                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                <table class="footable table table-stripped" data-filter=#filter>
                    <table class="footable table table-stripped nowrap three-col-fixed has-column-toggler" data-role="ui-data-table" data-url="{{ route('vendor-categories-data') }}" data-searching="false" data-ordering="false" data-page-size="50" data-fixed-header="true" data-fixed-header-columns-left="2">


                        <thead>

                            <tr>

                                <th data-col-name="id">#</th>

                                <th data-col-name="name">Vendor Category Name</th>

                                <th data-col-name="action">Action</th>

                            </tr>

                        </thead>

                        <tbody>


                        </tbody>

                        <tfoot>

                            <tr>

                                <td colspan="3">

                                    <ul class="pagination pull-right"></ul>

                                </td>

                            </tr>

                        </tfoot>

                    </table>

            </div>

        </div>

    </div>

</div>

@include('settings.vendor-categories.add-category')
@include('settings.vendor-categories.edit-category')
@include('settings.modals.confirm-delete')
@stop

@section('after_scripts')
@include('reports.scripts.common')
@include('reports.scripts.datatable')
@include('settings.vendor-categories.script')

@stop