@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'UPS Tracking Credential','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="ibox">

            <div class="ibox-content">

                @include('partials.success')
                @include('partials.error-message')

                <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter id="api-credential-table">

                    <thead>

                        <tr>
                            <th>#</th>
                            <th>URL</th>
                            <th>Username</th>
                            <th>Password</th>
                            <th>Access Key</th>
                            <th></th>
                        </tr>

                    </thead>

                    <tbody>

                        @if($credentials)
                        <tr>
                            <td>1</td>
                            <td>{{$credentials->url}}</td>
                            <td>{{$credentials->user_name}}</td>
                            <td>*****</td>
                            <td>*****</td>
                            <td>
                                @can('API Credentials Edit')
                                    <a href="/ups-tracking/{{$credentials->id}}/edit"><i class="icon icon-n-edit"></i></a>
                                @endcan
                            </td>
                        </tr>

                        @endif

                    </tbody>

                    <tfoot>

                        <tr>
                            <td colspan="6"></td>

                        </tr>

                    </tfoot>

                </table>

                <div class="row">
                    <div class="col-md-12">
                        <form method="post" action="/ups-tracking/manual-sync" class="form-inline">
                            @csrf
                            <button class="btn btn-primary" type="button" id="manual-sync">Manual Sync</button>
                            <span class="text-danger" id="sync-error"></span>
                            <span class="text-success" id="sync-success"></span>
                        </form>
                    </div>
                </div>

            </div>

        </div>

    </div>

</div>


@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection


@section('after_scripts')
@include('settings.partials.responsive-fixedheader')
<script>
    $(function () {
        $('.footable').footable();
        $("#manual-sync").click(function () {
            $("#sync-success").html('Manual sync started. Please wait. It may take a while.');
            $.ajax({
                type: "POST",
                url: "/ups-tracking/manual-sync",
                success: function(data) {
                    $("#sync-success").html('Manual sync completed. Count of updated assets '+data);
                },
                error: function(value) {
                    $("#sync-success").html('');
                    $("#sync-error").html('Error occurred in API connection.');
                }
            });
        });
    });
</script>
@endsection