@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Teqtivity Users','parentTitle' => 'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        
        <div class="ibox">

            <div class="ibox-content">

                <p><a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html" data-target="#addTeqtivityUser">Add New</a></p>

                @include('partials.error-list')
                @include('partials.success')

                <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter id="teq-user-table">

                    <thead>

                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Status</th>
                            <th></th>
                        </tr>

                    </thead>

                    <tbody>

                        @forelse($teqtivityUsers as $user)
                            <tr>

                                <td>{{$loop->iteration}}</td>
                                
                                <td>{{$user->user_name}}</td>
                                <td>{{$user->email}}</td>
                                <td>{{$user->status ? "Active" : "Inactive"}}</td>
                                <td>
                                    <div class="btn-group btn-group-sm" style="float: none;">
                                        <button data-id="{{ $user->id }}" data-name="{{$user->user_name}}" data-email="{{$user->email}}" data-status="{{$user->status}}" type="button" class="tabledit-edit-button btn btn-link" style="float: none;">
                                            <span class="icon icon-n-edit"></span>
                                        </button>
                                        <a class=" btn btn-link" style="float: none;" title="Reset Password" href="{{ url('/reset-teqtivity-user-password/'.$user->id) }}">
                                            <span class="icon icon-reload"></span>
                                        </a>

                                        <button data-id="{{ $user->id }}" data-name="{{$user->user_name}}" data-email="{{$user->email}}" type="button" class="delete-button btn btn-link" style="float: none;">
                                            <span class="icon icon-delete-forever"></span>
                                        </button>

                                        <form id="{{$user->id}}"
                                            action="{{ route('teqtivity-users.delete') }}" method="POST">
                                            <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                            <input type="hidden" id="user_id{{ $user->id }}" name="user_id" value="{{ $user->id }}">
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5">No Teqtivity users in the system.</td>
                            </tr>
                        @endforelse

                    </tbody>

                    <tfoot>

                        <tr>

                            <td colspan="5">

                                <ul class="pagination pull-right"></ul>

                            </td>

                        </tr>

                    </tfoot>

                </table>

            </div>

        </div>
    </div>

</div>


@include('settings.teqtivity-users.partials.add-teqtivity-user-modal')
@include('settings.teqtivity-users.partials.edit-teqtivity-user-modal')
@include('settings.teqtivity-users.partials.assign-histories-modal')
@include('settings.modals.confirm-delete')

@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.system_settings'),'helpTitle'=>config('help-links.help_titles.system_settings')])
@endsection

@section('after_scripts')
@include('settings.teqtivity-users.partials.scripts')
@stop
