@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Teqtivity Slack Notification App','parentTitle' => 'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
        
                <div class="ibox">

                    <div class="ibox-content">

                        @include('partials.error-message')
                        @include('partials.success')

                        <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter id="teq-user-table">

                            <thead>

                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Client ID</th>
                                    <th></th>
                                </tr>

                            </thead>

                            <tbody>

                                <tr>

                                    <td>1</td>
                                    <td>{{ $credentials->api_name }}</td>
                                    <td>{{ $credentials->user_name }}</td>
                                    <td>
                                        @can('API Credentials Edit')
                                        <a href="{{route('teqtivity-slack-notification-app.edit', ['teqtivity_slack_notification_app' => $credentials->id])}}"><i class="icon icon-n-edit"></i></a>
                                        @endcan
                                    </td>
                                </tr>

                            </tbody>

                            <tfoot>

                                <tr>

                                    <td colspan="5">

                                        <ul class="pagination pull-right"></ul>

                                    </td>

                                </tr>

                            </tfoot>

                        </table>

                    </div>

                </div>
            </div>
        </div>
    </div>

</div>

@stop

@section('after_scripts')
@include('assets.partials.scripts.common')

@stop
