<script src="/js/plugins/tabledit/tabledit-modified.js"></script>
<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>

<script src="/js/plugins/dataTables/datatables.min.js"></script>
<script src="/js/plugins/dataTables/dataTables.fixedHeader.min.js"></script>
<script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<link rel="stylesheet" href="/css/plugins/dataTables/responsive.dataTables.min.css">
<script src="/js/plugins/dataTables/dataTables.responsive.min.js"></script>
<script src="/js/hardware-filter.js"></script>
<script src="/js/sweetalert2.all.min.js"></script>
<script>

    @if ($errors -> count() > 0)
        $("#addHardwareStandard").modal({ show: true });
    @endif

    $(document).ready(function () {
        $('.modal').on('show.bs.modal', function (e) {
            $(".alert-danger").hide();
        });

        $('.chosen-select').chosen({ width: "100%" });
        $('.make_model').chosen({ width: "100%" });

        // Check/uncheck all checkboxes when the checkbox in the table header is clicked
        $('#checkAll').on('click', function () {
            var isHeaderCheckboxDisabled = $(this).is(':disabled');
            if (!isHeaderCheckboxDisabled) {
                $('.checkRow:not(:disabled)').prop('checked', $(this).prop('checked'));
                toggleActionButtonVisibility();
            }
        });

        // Click event for individual checkboxes in the table body
        $('#technical-specs-table tbody').on('click', '.checkRow', function () {
            var isIndividualCheckboxDisabled = $(this).is(':disabled');
            if (!isIndividualCheckboxDisabled) {
                var allChecked = $('.checkRow:not(:disabled):checked').length === $('.checkRow:not(:disabled)').length;
                $('#checkAll').prop('checked', allChecked);
                toggleActionButtonVisibility();
            }
        });

        function toggleActionButtonVisibility() {
            var checkedValues = [];
            $('#bulkDeleteButton').hide();
            $('.checkRow:checked:not(:disabled)').each(function () {
                var value = $(this).val();
                if (!checkedValues.includes(value)) {
                    $('#bulkDeleteButton').show();
                    return;
                }
            });
        }

        $(document).on('click', '#bulkDeleteButton', function (e) {
            e.preventDefault();
            $('#confirm-delete').modal('show');
            $('#confirm-message').html('Are you sure you want to delete?');
        });

        $(".confirm-delete-button").on("click", function (e) {
            e.preventDefault();
            var checkedValues = [];
            $('.checkRow:checked:not(:disabled)').each(function () {
                var value = $(this).val();
                if (!checkedValues.includes(value)) {
                    checkedValues.push(value);
                }else {
                    return false; // Exit the loop on the first duplication
                }
            });
            if(checkedValues.length > 0) {

                $('.ajax-loader').show();
                $.ajax({
                    type: "POST",
                    url: "technical-specs-bulk-delete",
                    data: { tech_spec_ids:checkedValues },
                    success: function (data) {
                        $('.ajax-loader').hide();
                        $('#confirm-delete').modal('hide');
                        $('#bulkDeleteButton').hide();
                        if (data == 'deleted') {
                            $('#success').show();
                            $('#success p').text("Technical specification deleted successfully.");
                        } else if (data == 'error') {
                            $('#error').show();
                            $('#error p').text("This Technical specification cannot be deleted as it has assets associated with it.");
                        }
                        $('html, body').animate({
                            scrollTop: $("#success").offset().top
                        }, 1000);

                        $('#technical-specs-filter-form').submit();
                    }
                })
            }
        });



        $('#submit').click(function () {
            $("#pageNo").val(1);
            $('#technical-specs-form').submit();
        });

        $("#technical_spec").on('change', function () {
            $("#pageNo").val(1);
            $('#technical-specs-filter-form').submit();
        });

        $(document).on('click', '.pagination a', function (event) {
            event.preventDefault();
            var page = $(this).attr('href').split('page=')[1];
            $("#pageNo").val(page);
            $('#technical-specs-filter-form').submit();
        });

        $('#pageLengthSelect').on('change', function() {
            $("#pageNo").val(1);
            $('#technical-specs-filter-form').submit();
        });

        var sortingColumn = '';
        var sortingDirection = 'asc';
        // Bind the event to the click of the th elements
        $('#technical-specs-table thead .th-sortable').on('click', function (event) {
            event.preventDefault();
            sortableIndexes = [4,5,6,7,11];
            var columnIndex = $(this).index();
            if (sortableIndexes.indexOf(columnIndex) === -1) {
                return; // If the columnIndex is not present in sortableIndexes, do not continue execution
            }
            var currentOrder = sortingColumn === columnIndex ? (sortingDirection === 'asc' ? 'desc' : 'asc') : 'asc';

            // Update the classes responsible for the sorting icon in the table header
            $('#technical-specs-table thead th')
            .removeClass('sorting_desc sorting_asc')
            .addClass('sorting');

            if (currentOrder === 'asc') {
            $(this).removeClass('sorting').addClass('sorting_asc');
            } else {
            $(this).removeClass('sorting').addClass('sorting_desc');
            }

            // Update the sortingColumn and sortingDirection variables
            sortingColumn = columnIndex;
            sortingDirection = currentOrder;

            // Submit the form with the updated sortingColumn and sortingDirection values
            $('#technical-specs-filter-form').trigger('submit');
        });

        $('#technical-specs-filter-form').submit(function (e) {
            e.preventDefault();
            var page = $("#pageNo").val();
            var pageLength = $("#pageLengthSelect").val();
            $('.ajax-loader').show();
            var formData = $(this).serializeArray();
            $('#asset_type').prop("disabled", true).trigger("chosen:updated");
            $('#manufacturer').prop("disabled", true).trigger("chosen:updated");
            $('#make_and_model').prop("disabled", true).trigger("chosen:updated");
            $('#technical_spec').prop("disabled", true).trigger("chosen:updated");

            $.ajax({
                type: "POST",
                url: "/technical-specs-search?page=" + page+'&page_legth='+pageLength+'&sort_column='+sortingColumn+'&sort_direction='+sortingDirection,
                data: formData,
                success: function (value) {

                    $('.ajax-loader').hide();
                    var dataTable = $("#technical-specs-table").DataTable();
                    // get the html table rows then
                    if ($.fn.DataTable.isDataTable('#technical-specs-table')) {
                        dataTable.clear();
                        dataTable.destroy();
                    }

                    $("tbody").empty().promise().done(function () {
                        $("tbody").html(value.techspec);
                        $(".p-links").html(value.links);
                    });

                    $('#technical-specs-table').Tabledit({
                        url: '/technical-specs-ajax',
                        columns: {
                            identifier: [1, 'id'],
                            editable: [[7, 'technical_spec'], [8, 'original_value'], [9, 'new_value']]
                        },
                        warningClass: 'success',
                        mutedClass: 'danger',
                        onDraw: function (data) {
                            var status = value.status;
                            $('#technical-specs-table tbody').find('tr').each(function (index) {
                                if (status[index]) {
                                    if (status[index].status == 1) {
                                        $(this).find('.btn-group').find('.tabledit-status-button').html('<span class="icon icon-check-single"></span>');
                                        $(this).find('.btn-group').find('.tabledit-status-button').removeClass('btn-danger').addClass('btn-primary');
                                    } else {
                                        $(this).find('.btn-group').find('.tabledit-status-button').html('<span class="icon icon-s-remove"></span>');
                                        $(this).find('.btn-group').find('.tabledit-status-button').removeClass('btn-primary').addClass('btn-danger');
                                    }
                                }
                            });
                        },
                        onSuccess: function (data) {
                            // $('.alert-success').alert('close');
                            if (data.status == 1) {
                                $(":focus").children('span').removeClass('glyphicon-remove');
                                $(":focus").children('span').addClass('glyphicon-ok');
                                $(":focus").removeClass('btn-danger').addClass('btn-primary');
                            } else {
                                $(":focus").children('span').removeClass('glyphicon-ok');
                                $(":focus").children('span').addClass('glyphicon-remove');
                                $(":focus").removeClass('btn-primary').addClass('btn-danger');
                            }

                            // $('.ajax-messages').hide();
                            if (data == 'success') {
                                $('#success').show();
                                $('#success p').text("Technical specification updated successfully.");
                            }
                            else if (data == 'deleted') {
                                $('#success').show();
                                $('#success p').text("Technical specification deleted successfully.");
                            } else if (data == 'error') {
                                $('#error').show();
                                $('#error p').text("This technical specification cannot be deleted as it has assets associated with it.");
                            } else if (typeof data === "object" && data.hasOwnProperty("success") && data.success === "success") {
                                $('#success').show();
                                $('#success p').text(data.message);
                            } else if (data == 'failed') {
                                $('#error').show();
                                $('#error p').text("Operation failed.");
                            }
                            $('html, body').animate({
                                scrollTop: $("#success").offset().top
                            }, 1000);
                        },
                        restoreButton: false
                    });
                },
                error: function (value) {

                }
            })
                .done(function () {
                    $('#asset_type').prop("disabled", false).trigger("chosen:updated");
                    $('#manufacturer').prop("disabled", false).trigger("chosen:updated");
                    $('#make_and_model').prop("disabled", false).trigger("chosen:updated");
                    $('#technical_spec').prop("disabled", false).trigger("chosen:updated");

                    $('#technical-specs-table').DataTable(
                        {
                            scrollCollapse: false,
                            lengthMenu: [
                                [50, 100, 200],
                                ['50', '100', '200']
                            ],
                            fixedHeader: {
                                header: true,
                            },
                            "columnDefs": [
                                { "orderable": true, "targets": [4,5,6,7,11] },
                                { "orderable": false, "targets": [0,2,3,8,9,10,12] }
                            ],
                            "bFilter": false,
                            "bLengthChange": false,
                            "bInfo": false,
                            "paging": false
                        }
                    );
                });

        });

        $.fn.serializeObject = function () {
            var obj = {};

            $.each(this.serializeArray(), function (i, o) {
                var n = o.name, v = o.value;

                obj[n] = obj[n] === undefined ? v
                    : $.isArray(obj[n]) ? obj[n].concat(v)
                        : [obj[n], v];
            });

            return obj;
        };
        $('#export-csv').on('click', function (e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({
                type: "POST",
                url: "/technical-specs/technical-specs-export",
                data: $('#technical-specs-filter-form').serializeObject(),
                dataType: 'text',
                success: function (result) {
                    var blob = new Blob([result]);
                    if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                        window.navigator.msSaveBlob(blob, "technical-specs.csv");
                    else {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
                        a.download = "technical-specs.csv";
                        document.body.appendChild(a);
                        a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });

        @can('Hardware Standards & Technical Specs Edit')
        $('#technical-specs-table').Tabledit({
            url: '/technical-specs-ajax',
            columns: {
                identifier: [1, 'id'],
                editable: [[7, 'technical_spec'], [8, 'original_value'], [9, 'new_value']]
            },
            warningClass: 'success',
            mutedClass: 'danger',
            onDraw: function (data) {
                var status = {!!$status!!};

            $('#technical-specs-table tbody').find('tr').each(function (index) {
                if (status[index]) {
                    if (status[index].status == 1) {
                        $(this).find('.btn-group').find('.tabledit-status-button').html('<span class="icon icon-check-single"></span>');
                        $(this).find('.btn-group').find('.tabledit-status-button').removeClass('btn-danger').addClass('btn-primary');
                    } else {
                        $(this).find('.btn-group').find('.tabledit-status-button').html('<span class="icon icon-s-remove"></span>');
                        $(this).find('.btn-group').find('.tabledit-status-button').removeClass('btn-primary').addClass('btn-danger');
                    }
                }
            });


        },
            onSuccess: function (data) {
                // $('.alert-success').alert('close');
                if (data.status == 1) {
                    $(":focus").children('span').removeClass('glyphicon-remove');
                    $(":focus").children('span').addClass('glyphicon-ok');
                    $(":focus").removeClass('btn-danger').addClass('btn-primary');
                } else {
                    $(":focus").children('span').removeClass('glyphicon-ok');
                    $(":focus").children('span').addClass('glyphicon-remove');
                    $(":focus").removeClass('btn-primary').addClass('btn-danger');
                }

                $('.ajax-messages').hide();
                if (data == 'success') {
                    $('#success').show();
                    $('#success p').text("Technical specification updated successfully.");
                }
                else if (data == 'deleted') {
                    $('#success').show();
                    $('#success p').text("Technical specification deleted successfully.");
                } else if (data == 'error') {
                    $('#error').show();
                    $('#error p').text("This technical specification cannot be deleted as it has assets associated with it.");
                } else if (typeof data === "object" && data.hasOwnProperty("success") && data.success === "success") {
                    $('#success').show();
                    $('#success p').text(data.message);
                } else if (data == 'failed') {
                    $('#error').show();
                    $('#error p').text("Operation failed.");
                }
                $('html, body').animate({
                    scrollTop: $("#success").offset().top
                }, 1000);
            },
            restoreButton : false
        });

    @endcan

    $('#technical-specs-table').DataTable(
        {
            scrollCollapse: false,
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            fixedHeader: {
                header: true,
            },
            "columnDefs": [
                { "orderable": true, "targets": [4,5,6,7,11] },
                { "orderable": false, "targets": [0,2,3,8,9,10,12] }
            ],
            "bFilter": false,
            "bLengthChange": false,
            "bInfo": false,
            "paging": false
        }
    );

    $("#asset_type").change(function () {
        $("#pageNo").val(1);
        $.ajax({
            type: "POST",
            data: { id: $(this).val() },
            url: "/assets-filter/list-manufacturer",
            success: function (data) {
                $('#manufacturer').empty().trigger('chosen:updated');

                $.each(data, function (key, value) {
                    $('#manufacturer').append($('<option>', {
                        value: value.id,
                        text: value.manufacturer
                    })).trigger('chosen:updated');
                })

            }
        }).done(function () {
            $('#technical-specs-filter-form').submit();
        });
    });

    $("#manufacturer").change(function () {
        $("#pageNo").val(1);
        var asset_type_id = $('#asset_type').val();
        $.ajax({
            type: "POST",
            data: { manufacturer_id: $(this).val(), asset_type_id: asset_type_id },
            url: "/assets-filter/list-hardware-with-manufacturer",
            success: function (data) {
                $('#make_and_model').empty().trigger('chosen:updated');

                $.each(data, function (key, value) {
                    $('#make_and_model').append($('<option>', {
                        value: value.id,
                        text: value.hardware
                    })).trigger('chosen:updated');
                })

            }
        }).done(function () {
            $('#technical-specs-filter-form').submit();
        });
    });

    $("#make_and_model").change(function () {
        $("#pageNo").val(1);
        $.ajax({
            type: "POST",
            data: { id: $(this).val() },
            url: "/assets-filter/listtechnics",
            success: function (data) {
                $('#technical_spec').empty().trigger('chosen:updated');

                $.each(data, function (key, value) {
                    $('#technical_spec').append($('<option>', {
                        value: value.id,
                        text: value.details
                    })).trigger('chosen:updated');
                })

            }
        }).done(function () {
            $('#technical-specs-filter-form').submit();
        });
    });


    });

</script>