@extends('layouts.settings')
@section('content')
    @include('partials.breadcrumb', ['breadcrumbTitle' => 'Documentation','parentTitle'=>'Settings','parentUrl'=>'/settings'])
    <div class="wrapper-content">
        <div class="container-fluid">

            <div class="ibox">
                <div class="ibox-content ibox-content-settings">
                    @include('partials.success')
                    @include('partials.error')
                    <form class="form-horizontal" method="post" action="/system-settings/documentation">
                        {{csrf_field()}}
                        <div class="form-group">
                            <label class="col-lg-3 control-label">Help Guide URL <span class="text-danger">*</span> </label>
                            <div class="col-lg-6">
                                <input type="text" name="help_guide_url" value="{{ $data['help_guide_url'] ?? old('help_guide_url') }}" class="form-control">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-lg-3 control-label">Help Guide Authentication Token <span class="text-danger">*</span> </label>
                            <div class="col-lg-6">
                                <input type="text" name="help_guide_authentication_token" value="" class="form-control">
                                @if($data['help_guide_authentication_token'])
                                <p>To keep the old help guide authentication token, leave this empty</p>
                                @endif
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-lg-3 control-label">API Guide URL <span class="text-danger">*</span> </label>
                            <div class="col-lg-6">
                                <input type="text" name="api_guide_url" value="{{ $data['api_guide_url'] ?? old('api_guide_url') }}" class="form-control">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-lg-3 control-label">Api Guide Authentication Token <span class="text-danger">*</span> </label>
                            <div class="col-lg-6">
                                <input type="text" name="api_guide_authentication_token" value="" class="form-control">
                                @if($data['api_guide_authentication_token'])
                                <p>To keep the old api guide authentication token, leave this empty</p>
                                @endif
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-lg-offset-3 col-lg-1">
                                <button class="btn btn-primary" name="commit" type="submit">Save</button>
                            </div>
                        </div>
                    </form>
                </div>

            </div>

        </div>
    </div>

@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.documentation'),'helpTitle'=>config('help-links.help_titles.documentation')])
@endsection

@section('after_scripts')
    <script src="/js/plugins/chosen/chosen.jquery.js"></script>
    <script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
    <script>
        $(document).ready(function() {
            $(".chosen-select").chosen({
                width: "100%"
            });
            $('.saveSettings').click(function() {
                if (!confirm('Are you sure you want to update the settings ?')) {
                    return false;
                }
            });
        });
    </script>
@endsection
