@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'State','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        
        <div class="ibox">
            
            <div class="ibox-content">
                
                @can('State Edit')
                <p><a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html"
                    data-target="#addState">Add New</a></p>
                    
                    @include('settings.partials.success-message')
                    @include('settings.partials.delete-message')
                    @endcan
                    
                    <form class="form-horizontal" method="get" id="search-form">
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="form-group">
                                    <input type="text" class="form-control" name="searchText"
                                    placeholder="Find a state"
                                    value="{{isset($_GET['searchText']) ? $_GET['searchText'] : ''}}"
                                    required>
                                </div>
                            </div>
                            
                            <div class="col-lg-2">
                                <input type="submit" class="btn btn-primary" id="search" value="Search">
                            </div>
                            <div class="col-lg-2">
                                <a href="{{route('state.index')}}" class="btn btn-primary">Show All</a>
                            </div>
                        </div>
                    </form>
                    
                    <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                    id="state-table">
                    
                    <thead>
                        
                        <tr>
                            <th style="display: none;"></th>
                            <th width="10%">#</th>
                            <th width="35%">Name</th>
                            <th width="35%">Country</th>
                        </tr>
                        
                    </thead>
                    
                    <tbody>
                        
                        @foreach($states as $state)
                        <tr>
                            <td style="display: none;">{{$state->id}}</td>
                            
                            <td>{{ $num++ }}</td>
                            
                            <td>{{$state->name}}</td>
                            
                            <td>{{optional($state->country)->name}}</td>
                            
                        </tr>
                        @endforeach
                        
                    </tbody>
                    
                </table>
                
                <div class="pull-right">{{$states->appends(['searchText' => request('searchText')])->links()}}
                </div>
                
            </div>
            
        </div>
        
    </div>
    
</div>




<div class="modal inmodal" id="addState" tabindex="-1" role="dialog">
    
    <div class="modal-dialog">
        
        <div class="modal-content animated fadeIn">
            
            <div class="modal-header">
                
                <button type="button" class="close" data-dismiss="modal"><span>×</span><span
                    class="sr-only">Close</span></button>
                    
                    <h4 class="modal-title">Add New State</h4>
                    
                </div>
                
                <div class="modal-body">
                    
                    @include('partials.error')
                    
                    <form class="form-horizontal" action="" method="post" id="state-form">
                        
                        {{csrf_field()}}
                        
                        <div class="form-group">
                            
                            <label class="col-lg-4 control-label">Country</label>
                            
                            <div class="col-lg-8">
                                @include('partials.dropdowns.country')
                                
                            </div>
                            
                        </div>
                        
                        <div class="form-group">
                            
                            <label class="col-lg-4 control-label">Name</label>
                            
                            <div class="col-lg-8">
                                
                                <input type="text" class="form-control" name="state" value="{{old('state')}}" required>
                                
                            </div>
                            
                        </div>
                        
                    </form>
                    
                </div>
                
                <div class="modal-footer">
                    
                    <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>
                    
                    <button type="button" class="btn btn-primary" id="submit">Save</button>
                    
                </div>
                
            </div>
            
        </div>
        
    </div>
    
    @stop
    
    @section('help-links')
    @include('help.help-links',['helpLink'=>config('help-links.help_links.state'),'helpTitle'=>config('help-links.help_titles.state')])
    @endsection
    
    @section('after_scripts')
    
    @include('settings.state.state-script')
    
    @stop