<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/tabledit/tabledit.js"></script>
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/plugins/dataTables/dataTables.fixedHeader.min.js"></script>

<script>

    @if ($errors->count() > 0)
        $("#addState").modal({ show: true });
    @endif

    $(document).ready(function () {

        $('.modal').on('show.bs.modal', function (e) {
            $(".alert-danger").hide();
        });

        $("#country_id").removeClass("select2").addClass("chosen-select");
        $('.chosen-select').chosen({ width: "100%" });
        $('.footable').DataTable({

            scrollCollapse: false,
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            fixedHeader: {
                header: true,
            },
            "order": [[2, "asc"]],
            "bFilter": false,
            "bLengthChange": false,
            "bInfo": false,

        })

        $('#submit').click(function () {
            $('#state-form').submit();
        });

        @can('State Edit')
        @if($states->count() > 0)
            $('#state-table').Tabledit({
                url: '/state-ajax',
                columns: {
                    identifier: [0, 'state_id'],
                    editable: [[2, 'name'], [3, 'country', 'select', JSON.stringify({!!$countries!!}), 'name']]
        }, warningClass: 'success',
            mutedClass: 'danger',
            onSuccess: function (data) {

                $('.ajax-messages').hide();
                if (data == 'success') {
                    $('#success').show();
                    $('#success p').text("State updated successfully.");
                }
                else if (data == 'Deleted Successfully') {
                    $('#success').show();
                    $('#success p').text("State deleted successfully.");
                } else if (data == 'error') {
                    $('#error').show();
                    $('#error p').text("This state cannot be deleted as it has locations associated with it.");
                }
                $('html, body').animate({
                    scrollTop: $("#success").offset().top
                }, 1000);
            },
            restoreButton : false
            });
            @endif
    @endcan

    });

</script>