@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => (isset($credential->id) ? "Edit" : "Add").' Spoke API Credential','parentTitle'=>'Settings','parentUrl'=>'/settings','parentSubTitle' => 'Spoke API Credential','parentSubUrl'=>'/spoke'])

<div class="wrapper-content">

	<div class="container-fluid">
    	<div class="ibox">

			@include('partials.error')

			<div class="ibox-content ibox-content-settings">

				<form class="form-horizontal" method="post" action="{{route('spoke.update', $credential->id ?? 0)}}">

					{{csrf_field()}}

					<input type="hidden" name="_method" value="PUT">


					<div class="form-group">
						<label class="col-lg-3 control-label">URL</label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="url" value="{{ old('url',$credential->url ?? '') }}">
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">API Key</label>
						<div class="col-lg-6">
							<input type="password" class="form-control" name="key" value="{{ old('key') }}">
							<span class="help-block m-b-none">To keep the old key, leave this empty</span>
						</div>
					</div>

					<div class="form-group">
						<div class="col-lg-offset-3 col-lg-1">
							<button class="btn btn-primary" name="commit" type="submit">Save</button>
						</div>

					</div>

				</form>

			</div>
		</div>
	</div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection


@section('after_scripts')
@include('assets.partials.scripts.common')
@stop