@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Slack','parentTitle' => 'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">

        <div class="ibox">

            <div class="ibox-content">

                @include('partials.success')
                @include('partials.error-message')
                
                <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                id="api-credential-table" style="text-align:left">
                
                    <thead>
                        
                        <tr>
                            <th>#</th>
                            <th>App Id</th>
                            <th>Connection Status</th>
                            <th>Connect</th>
                            <th  style="width:100px"></th>
                        </tr>
                        
                    </thead>
                    
                    <tbody>
                        
                        @if($credentials)
                        <tr>
                            <td>1</td>
                            <td>{{$credentials->user_name}}</td>
                            @if($status == 1)
                                <td><button class="btn btn-primary"
                                    style="background-color: #5cb85c;  border-color: #4cae4c;">Active</button>
                                </td>
                                <td>
                                    <a href="#" class="btn btn-primary disabled ">Connect</a>
                                </td>
                            @else
                                <td> <button class="btn btn-danger" style="pointer-events:none;">Inactive</button></td>
                                <td> <a href="{{url('slack/connect')}}" class="btn btn-primary ">Connect</a></td>
                            @endif
                            <td style="width:100px">
                                @can('API Credentials Edit')
                                <a href="/slack/{{$credentials->id}}/edit" class="dropbox-edit"><i class="icon icon-n-edit"></i> </a>

                                <label class="toggle-switch">
                                    <input type="checkbox" id="toggleButton" @if($credentials->integration_status == 1) checked @endif>
                                    <span class="toggle-slider"></span>
                                </label>  
                                @endcan                         
                            </td>
                        </tr>
                        @else
                            <tr>
                                <td colspan="5">No Api Credentials in the system.</td>
                            </tr>
                        @endif
                                
                    </tbody>
                            
                    <tfoot>
                                
                        <tr>
                            <td colspan="5">
                                
                            </td>
                            
                        </tr>
                        
                    </tfoot>
                        
                </table>
                    
                    
                <div class="row">
                    <div class="col-md-12">
                        <a href="/slack/manual-sync" id="manualSync" class="btn btn-primary btn-sm" @if($status != 1 || $credentials->integration_status != 1) style="display:none" @endif> Manual
                            Sync</a>
                            <span style="color:red;display:none" id="manualSyncValidationmsg"></span>
                        </div>
                    
                </div>
                      
                        
            </div>

        </div>


    </div>

</div>

@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection

@section('after_scripts')
@include('settings.slack.script')
@include('settings.partials.responsive-fixedheader')
@endsection