@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Slack Connection','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">

        <div class="ibox">
            <div class="ibox-content ibox-content-settings">
                @include('partials.error')
                <form class="form-horizontal" method="post" action="{{route('slack.store')}}">
                    {{csrf_field()}}
                    <div class="form-group">
                        <label class="col-lg-3 control-label">App ID</label>
                        <div class="col-lg-6">
                            <input type="text" class="form-control" name="app_name" value="{{ old('app_name') }}">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-3 control-label">Client ID <span class="text-danger">*</span> </label>
                        <div class="col-lg-6">
                            <input type="password" class="form-control" name="app_key" >
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-3 control-label">Client secret <span class="text-danger">*</span> </label>
                        <div class="col-lg-6">
                            <input type="password" class="form-control" name="app_secret" >
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <div class="col-lg-offset-3 col-lg-1">
                            <button class="btn btn-primary" name="commit" type="submit">Save</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>


    </div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection

@section('after_scripts')
@include('assets.partials.scripts.common')
@stop