@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Edit Slack Notifications Configuration','parentTitle'=>'Settings','parentUrl'=>'/settings', 'parentSubTitle' => 'Slack Notifications','parentSubUrl'=>'/slack-notifications'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">

                <div class="ibox">

                    <div class="ibox-content">

                        <form class="form-horizontal" method="post" action="{{route('slack-notifications-config.update', ['slack_notifications_config' => $credential->id])}}">

                            {{csrf_field()}}

                            @method('PUT')

                            @include('partials.error')

                            <div class="ibox-content">

                                <div class="form-group row align-items-center">
                                    <label class="col-lg-3 control-label" for="channel_id">Channel ID</label>
                                    <div class="col-lg-6">
                                        <input type="text" class="form-control" id="channelId" name="channel_id" value="{{ $credential->channel_id }}">
                                    </div>
                                    <div class="col-lg-3">
                                        <button class="btn btn-primary" type="button" id="searchChannel">Search</button>
                                    </div>
                                </div>

                                <div class="form-group row align-items-center">
                                    <label class="col-lg-3 control-label" for="channel_name">Channel Name</label>
                                    <div class="col-lg-6">
                                        <input type="text" class="form-control" id="channelName" name="channel_name" value="{{ $credential->channel_name }}" readonly>
                                        <label class="text-danger" id="channelNameError"></label>
                                    </div>
                                    <div class="col-lg-3">
                                        <button class="btn btn-primary" name="commit" type="submit" id="saveButton" disabled>Save</button>
                                        <button class="btn btn-info" type="button" id="resetButton">Reset</button>
                                    </div>
                                </div>

                            </div>
     
                        </form>
                    </div>

                </div>
            </div>
        </div>

    </div>

</div>
@stop

@section('after_scripts')
@include('assets.partials.scripts.common')
<script>
    $(document).ready(function () {
        $('#searchChannel').click(function(e) {
            e.preventDefault();
            var channelId = $('#channelId').val();

            if(channelId === '' || channelId === undefined || channelId === null) {
                $("#channelNameError").text('Please enter channel ID');
                return false;
            }

            $("#channelNameError").text('');
            $('#saveButton').prop('disabled', true);
            $('#channelId').attr('readonly', true);

            // Example AJAX request to get channel name
            $.ajax({
                url: '/search-slack-channel',
                method: 'GET',
                data: { channel_id: channelId },
                success: function(response) {
                    if(response.success) {
                        $('#channelName').val(response.channel_name);
                        $('#channelId').val(response.channel_id);
                        $('#saveButton').prop('disabled', false);
                        $('#searchChannel').prop('disabled', true);
                    }else{
                        $('#channelId').attr('readonly', false);
                        $("#channelNameError").text(response.message);
                    }
                },
                error: function() {
                    $('#channelId').attr('readonly', false);
                    $("#channelNameError").text('Error retrieving channel name');
                }
            });
        });

        $('#resetButton').click(function(e) {
            e.preventDefault();
            $('#channelName').val('');
            $('#channelId').val('');
            $('#saveButton').prop('disabled', true);
            $('#channelId').removeAttr('readonly');
            $('#searchChannel').prop('disabled', false);
        });
    })
</script>
@stop