@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Slack Notifications','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">

                <div class="ibox">

                    <div class="ibox-content">

                        @include('partials.success')
                        @include('partials.error-message')


                        <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter id="api-credential-table">

                            <thead>

                                <tr>
                                    <th>#</th>
                                    <th>Identifier</th>
                                    <th>Connect</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>

                            </thead>

                            <tbody>
                                <tr>
                                    @if(!empty($credential))
                                    <td>1</td>
                                    <td>{{ $credential->api_name }}</td>
                                    <td>
                                        @can('API Credentials Edit')
                                        @if(!$credential->key)
                                        <a class="btn btn-primary" href="{{route('slack-notifications.connect')}}">Connect</a>
                                        @else
                                        <a class="btn btn-primary" href="javascript:void(0)" disabled>Connect</a>
                                        @endif
                                        @endcan
                                    </td>
                                    <td>{{ $credential->key ? 'Connected' : 'Not Connected' }}</td>
                                    <td>
                                        @can('API Credentials Edit')
                                        @if($credential->key)
                                        <a class="btn btn-primary" href="{{route('slack-notifications.reset', ['slack_api_credential' => $credential->id])}}">Reset</a>
                                        @else
                                        <a class="btn btn-primary" href="javascript:void(0)" disabled>Reset</a>
                                        @endif
                                        @endcan
                                    </td>
                                    @else
                                    <td colspan="5" class="text-center">No Record Found</td>
                                    @endif
                                </tr>

                            </tbody>

                            <tfoot>

                                <tr>

                                    <td colspan="5">

                                        <ul class="pagination pull-right"></ul>

                                    </td>

                                </tr>

                            </tfoot>

                        </table>

                    </div>

                </div>
            </div>
        </div>


        <!-- new section -->

        <div class="row">
            <div class="col-lg-12">

                <div class="ibox">

                    <div class="ibox-title">
                        <h3>Slack Notifications Configuration</h3>
                    </div>

                    <div class="ibox-content">

                        @include('partials.sync-messages')

                        @if($configurationData===true)
                            <table class="footable table table-striped nowrap" id="slack-configurations-table" data-role="ui-data-table" data-url="{{ route('slack-notification-channels-data') }}" data-searching="false" data-ordering="false" data-page-size="50" data-fixed-header="true">

                                <thead>

                                    <tr>
                                        <th data-col-name="id">#</th>
                                        <th data-col-name="name">Notification</th>
                                        <th data-col-name="channel_name">Channel Name</th>
                                        <th data-col-name="connection">Connection</th>
                                        <th data-col-name="toggle_switch">Status</th>
                                        <th data-col-name="edit_button">Edit</th>
                                        <th data-col-name="test_button">Test</th>
                                    </tr>

                                </thead>

                                <tbody>

                                </tbody>

                                <tfoot>

                                    <tr>

                                        <td colspan="6">

                                            <ul class="pagination pull-right"></ul>

                                        </td>

                                    </tr>

                                </tfoot>

                            </table>
                        @else
                            <h4 class="text-center">No Record Found</h4>
                        @endif
                    </div>
                </div>
            </div>

        </div>


        <!-- new section end -->


    </div>
</div>


@stop

@section('after_scripts')
@include('reports.scripts.common')
@include('reports.scripts.datatable')
<script>
    $(document).ready(function() {

        $(document).on('change', '.messagingToggleButton', function() {
            $(".sync-msg").hide();
            var credentialId = $(this).data('notification-id');
            var status = this.checked ? 1 : 0;
            $.ajax({
                type: "POST",
                url: "/update-slack-notifications-status",
                data: {
                    id: credentialId,
                    status: status
                },
                success: function(response) {
                    if (response.success) {
                        $('#sync-success').show();
                        $('#sync-success-msg').text(response.message);


                        if ($('#test-notification-btn-' + credentialId).length == 0) {
                            return false;
                        }

                        let connectedStatus = $('#test-notification-btn-' + credentialId).data('connected-status');

                        if (status == 1 && connectedStatus == 'connected') {
                            $('#test-notification-btn-' + credentialId).removeAttr('disabled');
                            $('#test-notification-btn-' + credentialId).css('pointer-events', 'auto');
                        } else {
                            $('#test-notification-btn-' + credentialId).attr('disabled', 'disabled');
                            $('#test-notification-btn-' + credentialId).css('pointer-events', 'none');
                        }

                    } else {
                        $('#sync-error').show();
                        $('#sync-error-msg').text(response.error);
                    }
                },
                error: function(error) {
                    $('#sync-error').show();
                    $('#sync-error-msg').text("Operation failed. Please try again later.");
                }
            });
        });
    });
</script>
@stop