@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Slack Notification Webhooks','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        
        <div class="ibox">
            
            <div class="ibox-content">
                
                @include('partials.success')
                @include('partials.error-message')
                
                <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                id="api-credential-table">
                
                    <thead>
                        
                        <tr>
                            <th>#</th>
                            <th>Identifier</th>
                            <th>Webhook Url</th>
                            <th>Action</th>
                        </tr>
                        
                    </thead>
                    
                    <tbody>
                        
                        @forelse($credentials as $credential)
                            <tr>
                                <td>{{$loop->iteration}}</td>
                                <td>{{$credential->name}}</td>
                                <td>{{$credential->webhook_url}}</td>
                                <td>@can('API Credentials Edit')<a href="{{route('slack-notification-credentials.edit', ['slack_notification_credential' => $credential->id])}}"><i class="icon icon-n-edit"></i></a>@endcan</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4">No details in the system.</td>
                            </tr>
                        @endforelse

                    </tbody>
                        
                    <tfoot>
                        
                        <tr>
                            
                            <td colspan="4">
                                <ul class="pagination pull-right"></ul>
                            </td>
                            
                        </tr>
                        
                    </tfoot>
                    
                </table>

                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                <div class="row">
                    <div class="col-md-12">
                        <button id="notify-manually" class="btn btn-primary btn-sm"> Notify Now</button>
                    </div>
                    
                </div>
                <br>
                
                <div class="alert alert-success" id="notify-manually-success" style="display:none">
                    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
                    <strong>Success!</strong> Notification send successfully
                </div>

                <div class="alert alert-danger" id="notify-manually-error" style="display:none">
                    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
                    <strong>Error!</strong> Something went wrong. Try again later
                </div>

            </div>
            
        </div>
        
    </div>
    
</div>

@stop
@section('after_scripts')
<script>
    $('#notify-manually').on('click', function (e) {
        $(this).prop("disabled", true);
        $(".ajax-loader").show();
        $("#notify-manually-error").hide();
        $("#notify-manually-success").hide();
        $.ajax({
            type: "GET",
            url: 'slack-notification-credentials/notify-manually',
            success: function(response) {
                $(".ajax-loader").hide();
                $('#notify-manually').prop("disabled", false);

                if (response) {
                    $("#notify-manually-success").show();       
                } else {
                    $("#notify-manually-error").show();
                }
            },
            error: function(xhr, status, error) {
                $(".ajax-loader").hide();
                $("#notify-manually-error").show();
                $('#notify-manually').prop("disabled", false);   
            },
            cache: false,
            contentType: false,
            processData: false
        }).fail(function () {
            $('.ajax-loader').hide();
            $("#notify-manually-error").show();
            $('#notify-manually').prop("disabled", false);
        });
    });
</script>
@include('settings.partials.responsive-fixedheader')
@stop