@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Edit Slack Webhook Url','parentTitle'=>'Settings','parentUrl'=>'/settings','parentSubTitle'=>'Slack Notification Webhooks','parentSubUrl'=>'/slack-notification-credential'])

<div class="wrapper-content">

	<div class="container-fluid">
		<div class="ibox">
			@include('partials.error')
			<div class="ibox-content">

				<form class="form-horizontal" method="post"
					action="{{route('slack-notification-credentials.update', ['slack_notification_credential' => $credential->id])}}">

					{{csrf_field()}}

					@method('PUT')

					<div class="form-group">
                        <label class="col-lg-3 control-label">Webhook Name</label>
                        <div class="col-lg-6">
                            <input type="text" class="form-control" name="webhook_url" value="{{$credential->name}}" disabled>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-lg-3 control-label">Webhook URL</label>
                        <div class="col-lg-6">
                            <input type="text" class="form-control" name="webhook_url" value="{{$credential->webhook_url}}">
                        </div>
                    </div>

                    <div class="form-group">
						<div class="col-lg-offset-3 col-lg-1">
							<button class="btn btn-primary" name="commit" type="submit">Update</button>
						</div>
					</div>

				
				</form>
			</div>
				
		</div>

	</div>
</div>
@stop

@section('after_scripts')
@include('assets.partials.scripts.common')
@stop