@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Site Codes','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="ibox">
            
            <div class="ibox-content">
                
                @can('Site Code Edit')
                <p><a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html"
                    data-target="#addSiteCode">Add New</a>
                </p>
                
                <form class="form-horizontal" action="/site-code/upload" method="post"
                id="upload-asset-form" enctype="multipart/form-data">
                
                {{csrf_field()}}
                
                <div class="row">
                    
                    <div class="col-lg-8">
                        
                        <div class="form-group">
                            
                            <label class="col-lg-4 control-label">Bulk Upload</label>
                            
                            <div class="col-lg-8">
                                
                                <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                    
                                    <div class="form-control" data-trigger="fileinput">
                                        
                                        <i class="glyphicon glyphicon-file fileinput-exists"></i>
                                        
                                        <span class="fileinput-filename"></span>
                                        
                                    </div>
                                    
                                    <span class="input-group-addon btn btn-primary btn-file">
                                        
                                        <span class="fileinput-new">Select file</span>
                                        
                                        <span class="fileinput-exists">Change</span>
                                        
                                        <input type="file" name="bulk_upload_asset"
                                        id="bulk_upload_asset" />
                                        
                                    </span>
                                    
                                    <a href="#" class="input-group-addon btn btn-primary fileinput-exists"
                                    data-dismiss="fileinput">Remove</a>
                                    
                                </div>
                                <a href="/template/sitecode-template.csv" class="btn btn-link pull-right">Download Template
                                    File</a>
                                </div>
                                
                            </div>
                            
                        </div>
                        
                        <div class="col-lg-4">
                            
                            <input type="submit" class="btn btn-primary" value="Upload" id="upload-button">
                            
                            
                            
                        </div>
                        
                    </div>
                    
                </form>
                @endcan
                
                <form class="form-horizontal" method="get" id="search-form">
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="form-group">
                                <input type="text" class="form-control" name="searchText"
                                placeholder="Find a site code"
                                value="{{isset($_GET['searchText']) ? $_GET['searchText'] : ''}}"
                                required>
                            </div>
                        </div>
                        
                        <div class="col-lg-2">
                            <input type="submit" class="btn btn-primary" id="search" value="Search">
                        </div>
                        <div class="col-lg-2">
                            <a href="{{route('site-code.index')}}" class="btn btn-primary">Show All</a>
                        </div>
                    </div>
                </form>
                
                @include('partials.success')
                @include('settings.partials.success-message')
                @include('settings.partials.delete-message')
                @include('partials.error-message')
                
                <table class="table footable table-stripped table-hover" data-page-size="25" data-filter=#filter
                id="site-codes-table">
                
                <thead>
                    
                    <tr>
                        <th style="display: none;"></th>
                        <th>#</th>
                        
                        <th>Site Code</th>
                        
                        <th>Region</th>
                        
                        <th>Country</th>
                        
                    </tr>
                    
                </thead>
                
                <tbody>
                    @foreach($siteCodes as $siteCode)
                    <tr>
                        <td style="display: none;">{{$siteCode->id}}</td>
                        <td>{{ $num++ }}</td>
                        
                        <td>{{$siteCode->code}}</td>
                        
                        <td>{{optional($siteCode->region)->name}}</td>
                        
                        <td>{{optional($siteCode->country)->name}}</td>
                        
                    </tr>
                    @endforeach
                </tbody>
                
                <tfoot>
                    <tr>
                        <td colspan="5"><div class="pull-right">{{$siteCodes->appends(['searchText' =>
                            request('searchText')])->links()}}</div></td>
                            
                        </tr>
                    </tfoot>
                    
                </table>
                
            </div>
        </div>
    </div>
</div>


<div class="modal inmodal" id="addSiteCode" tabindex="-1" role="dialog">
    
    <div class="modal-dialog">
        
        <div class="modal-content animated fadeIn">
            
            <div class="modal-header">
                
                <button type="button" class="close" data-dismiss="modal"><span>×</span><span
                    class="sr-only">Close</span></button>
                    
                    <h4 class="modal-title">Add New Site Code</h4>
                    
                </div>
                
                <div class="modal-body">
                    
                    @include('partials.error')
                    
                    <form class="form-horizontal" action="" method="post" id="site-codes-form">
                        
                        {{csrf_field()}}
                        
                        <div class="form-group">
                            
                            <label class="col-lg-4 control-label">Site Codes</label>
                            
                            <div class="col-lg-8">
                                
                                <input type="text" class="form-control" name="site_code" value="{{old('site_code')}}"
                                required>
                                
                            </div>
                            
                        </div>
                        
                        <div class="form-group">
                            
                            <label class="col-lg-4 control-label">Region</label>
                            
                            <div class="col-lg-8">
                                @include('partials.dropdowns.region')
                                
                            </div>
                            
                        </div>
                        
                        <div class="form-group">
                            
                            <label class="col-lg-4 control-label">Country</label>
                            
                            <div class="col-lg-8">
                                @include('partials.dropdowns.country')
                                
                            </div>
                            
                        </div>
                        
                    </form>
                    
                </div>
                
                <div class="modal-footer">
                    
                    <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>
                    
                    <button type="button" class="btn btn-primary" id="submit">Save</button>
                    
                </div>
                
            </div>
            
        </div>
        
    </div>
    
    @stop
    
    @section('help-links')
    @include('help.help-links',['helpLink'=>config('help-links.help_links.site_code'),'helpTitle'=>config('help-links.help_titles.site_code')])
    @endsection
    
    @section('after_scripts')
    
    @include('settings.site-code.site-code-script')
    
    @stop