<script src="/js/plugins/tabledit/tabledit.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/plugins/dataTables/dataTables.fixedHeader.min.js"></script>
<script>

    @if ($errors -> count() > 0)
        $("#addSiteCode").modal({ show: true });
    @endif

    $(document).ready(function () {

        $('.modal').on('show.bs.modal', function (e) {
            $(".alert-danger").hide();
        });

        $('.footable').DataTable({

            scrollCollapse: false,
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            fixedHeader: {
                header: true,
            },
            "order": [[2, "asc"]],
            "bFilter": false,
            "bLengthChange": false,
            "bInfo": false,
            "paging":false

        })

        $('#submit').click(function () {
            $('#site-codes-form').submit();
        });

        $('#search').click(function () {
            $('#search-form').submit();
        });


        @can('Site Code Edit')
        $('#site-codes-table').Tabledit({
            url: '/site-codes-ajax',
            columns: {
                identifier: [0, 'id'],
                editable: [[2, 'site_code'], [3, 'region', 'select', JSON.stringify({!!$regions!!})], [4, 'country', 'select', JSON.stringify({!!$countries!!}), 'name']]
            },
    warningClass: 'success',
        mutedClass: 'danger',
            onSuccess: function (data) {
                $('.ajax-messages').hide();
                if (data == 'success') {
                    $('#success').show();
                    $('#success p').text("Site code updated successfully.");
                }
                else if (data == 'Deleted Successfully') {
                    $('#success').show();
                    $('#success p').text("Site code deleted successfully.");
                } else if (data == 'error') {
                    $('#error').show();
                    $('#error p').text("This site code cannot be deleted as it has locations associated with it.");
                }
                $('html, body').animate({
                    scrollTop: $("#success").offset().top
                }, 1000);
                // $('#site-codes-table').trigger('footable_redraw');
            },
    restoreButton: false
        });
    @endcan

    });



</script>