@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'SHI Credential','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="ibox">
            
            <div class="ibox-content">
                
                @include('partials.error-message')
                @include('partials.success')
                
                <table class="table table-stripped table-hover" data-page-size="50" data-filter=#filter id="api-credential-table">
                    
                    <thead>
                        
                        <tr>
                            <th>Name</th>
                            <th>URL</th>
                            <th>Status</th>
                            <th>Edit</th>
                        </tr>
                        
                    </thead>
                    
                    <tbody>
                        
                        @if($credentials)
                        <tr>
                            <td>{{$credentials->api_name}}</td>
                            <td>{{$credentials->url}}</td>
                            <td>@if($status)
                                <a href="#" class="btn btn-primary btn-sm" disabled>Active</a>
                                @else
                                <a href="#" class="btn btn-danger btn-sm" disabled>Inactive</a>
                                @endif
                            </td>
                            <td>
                                @can('API Credentials Edit')
                                <a href="{{route('asn-shi-api-settings.edit', ['asn_shi_api_setting' => $credentials->id])}}"><i class="icon icon-n-edit"></i></a>
                                @endcan
                            </td>
                        </tr>
                        @else
                        <tr>
                            <td colspan="4">No SHI Credentials in the system.</td>
                        </tr>
                        @endif
                        
                    </tbody>
                    
                    <tfoot>
                        
                        <tr>
                            
                            <td colspan="4">
                                
                                <ul class="pagination pull-right"></ul>
                                
                            </td>
                            
                        </tr>
                        
                    </tfoot>
                    
                </table>
                
            </div>
            
        </div>
        
    </div>
    
</div>


@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection


@section('after_scripts')
@include('assets.partials.scripts.common')
@stop