@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'ASN-SHI Credential','parentTitle'=>'Settings','parentUrl'=>'/settings','parentSubTitle' => 'SHI Credential','parentSubUrl'=>'/asn-shi-api-settings'])

<div class="wrapper-content">
	<div class="container-fluid">
		<div class="ibox">
			<div class="ibox-content ibox-content-settings">
				
				@include('partials.error')
				
				<form class="form-horizontal" method="post" action="{{route('asn-shi-api-settings.store')}}">
					
					{{csrf_field()}}
					
					<div class="form-group">
						<label class="col-lg-3 control-label">Client ID</label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="user_name" value="" required>
						</div>
					</div>
					
					<div  class="form-group">
						<label class="col-lg-3 control-label">Secret</label>
						<div class="col-lg-6">
							<input type="password" class="form-control" name="password" value="" required>
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-lg-3 control-label">URL</label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="url" value="" required>
						</div>
					</div>
					
					<div class="form-group">
						<div class="col-lg-offset-3 col-lg-1">
							<button class="btn btn-primary" name="commit" type="submit">Save</button>
						</div>
					</div>
				</form>
				
			</div>
		</div>
	</div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection


@section('after_scripts')
@include('assets.partials.scripts.common')
@stop