@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Revivn Credentials','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">

        <div class="ibox">

            <div class="ibox-content">

                @include('partials.success')
                @include('partials.error-message')

                <table class="footable table table-stripped table-hover" id="api-credential-table">

                    <thead>

                        <tr>
                            <th>Name</th>
                            <th>URL</th>
                            <th>Client ID</th>
                            <th>Client Secret</th>
                        </tr>

                    </thead>

                    <tbody>

                    @if ($credentials)
                        <tr>
                            <td>Revivn</td>
                            <td>{{$credentials->url}}</td>
                            <td>******</td>
                            <td>******</td>
                            <td>@can('API Credentials Edit')<a href="/revivn/{{$credentials->id}}/edit"><i class="icon icon-n-edit"></i></a>@endcan</td>
                        </tr>
                    @else
                        <tr>
                            <td colspan="5">No API credentials in the system.</td>
                        </tr>
                    @endif

                    </tbody>

                    <tfoot>

                        <tr>
                            <td colspan="5">

                            </td>

                        </tr>

                    </tfoot>

                </table>

            </div>

        </div>
    </div>

</div>


@stop

@section('after_scripts')

@endsection