@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Edit Revivn Credentials','parentTitle'=>'Settings','parentUrl'=>'/settings','parentSubTitle'=>'Revivn','parentSubUrl'=>'/revivn'])

<div class="wrapper-content">
    <div class="container-fluid">
		<div class="row">
			<div class="col-lg-12">
	            <div class="ibox">
					<div class="ibox-content">

						<form class="form-horizontal" method="post" action="/revivn/{{$credential->id}}">

							{{csrf_field()}}

							@method('PUT')

							@include('partials.error')
										
							<div class="form-group">
								<label class="col-lg-3 control-label">API URL</label>
								<div class="col-lg-6">
									<input type="text" class="form-control" name="url" value="{{$credential->url}}">
								</div>
							</div>

							<div class="form-group">
								<label class="col-lg-3 control-label">Client ID</label>
								<div class="col-lg-6">
									<input type="password" class="form-control" name="user" value="">
									<span class="help-block m-b-none">To keep the old Client ID, leave this empty</span>
								</div>
							</div>

							<div class="form-group">
								<label class="col-lg-3 control-label">Client Secret</label>
								<div class="col-lg-6">
									<input type="password" class="form-control" name="password" value="">
									<span class="help-block m-b-none">To keep the old Client Secret, leave this empty</span>
								</div>
							</div>

							<div class="form-group">
								<div class="col-lg-offset-3 col-lg-1">
									<button class="btn btn-primary" name="commit" type="submit">Update</button>
								</div>
							</div>
							
						</form>
						
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@stop

@section('after_scripts')
    @include('assets.partials.scripts.common')
@stop