@extends('layouts.main')
@section('content')
    @include('partials.breadcrumb', ['breadcrumbTitle' => 'Retriever Credential'])
    <div class="wrapper-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="ibox">
                        <div class="ibox-content">
                            @include('partials.error-message')
                            @include('partials.success')
                            <div class="alert alert-danger" id="sync-error" style="display: none;">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            </div>
                            <div class="alert alert-success" id="sync-success" style="display: none;">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            </div>
                            <table class="table table-stripped table-hover" data-page-size="50" data-filter=#filter id="api-credential-table">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>URL</th>
                                        <th>Status</th>
                                        <th>Edit</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if ($credentials)
                                        <td>{{ $credentials->api_name }}</td>
                                        <td>{{ $credentials->url }}</td>
                                        <td>
                                            @if ($connectionStatus)
                                                <a href="#" class="btn btn-primary btn-sm" disabled>Active</a>
                                            @else
                                                <a href="#" class="btn btn-danger btn-sm" disabled>Inactive</a>
                                            @endif
                                        </td>
                                        <td>
                                        @can('API Credentials Edit')
                                        <a href="{{route('retriever-credentials.edit', ['retriever_credential' => $credentials->id])}}"><i
                                                class="icon icon-n-edit"></i></a>
                                        @endcan
                                        </td>
                                        <td>
                                            @if ($connectionStatus)
                                            <button class="btn btn-primary btn-sm" id="retriever-sync">Manual Sync</a>
                                            @endif
                                        </td>
                                    @else
                                        <tr>
                                            <td colspan="5">Credentials not found.</td>
                                        </tr>
                                    @endif
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="5">
                                            <ul class="pagination pull-right"></ul>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
@section('after_scripts')
    @include('assets.partials.scripts.common')

<script>
    $("#retriever-sync").click(function (e) {
        e.preventDefault();
        $('#retriever-sync').hide();
            $("#sync-success").html('Retriever sync started. Please wait. It may take a while.').show();
            $.ajax({
                type: "post",
                url: "/retriever-manual-sync",
                success: function(data) {
                    if(data.status== 'success'){
                        $("#sync-success").html(data.message);
                    }else{
                        $("#sync-success").html('').hide();
                        $("#sync-error").html(data.message).show();
                    }

                    $('#retriever-sync').show();
                },
                error: function() {
                    $("#sync-success").html('').hide();
                    $("#sync-error").html('Error while syncing. Please try again.').show();
                    $('#retriever-sync').show();
                }
            });
        });
</script>
@endsection