@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Edit Retriever Credential'])
<div class="wrapper-content">
	<div class="container-fluid">
    	<div class="row">
	    	<div class="col-lg-12">
	            <div class="ibox">
	                <div class="ibox-content ibox-content-settings">
	                	@include('partials.error')
				    	<form class="form-horizontal" method="post" action="{{route('retriever-credentials.update', ['retriever_credential' => $credentials->id])}}">
				    		{{csrf_field()}}
				    		<input type="hidden" name="_method" value="PUT">
							<div class="form-group">
		                        <label class="col-lg-3 control-label">URL</label>
		                        <div class="col-lg-6">
		                            <input type="text" class="form-control" name="url" value="{{$credentials->url}}" required>
		                        </div>
		                    </div>

							<div class="form-group">
		                        <label class="col-lg-3 control-label">API Token</label>
		                        <div class="col-lg-6">
		                            <textarea class="form-control" name="token"  cols="30" rows="10"></textarea>
		                            <span class="help-block m-b-none">To keep the old token, leave this text area empty.</span>
		                        </div>
		                    </div>
		                    <div class="form-group">
								<div class="col-lg-offset-3 col-lg-1">
									<button class="btn btn-primary" name="submit_form_button" type="submit">Update</button>
								</div>
							</div>
						</form>
	                </div>
		        </div>
		    </div>
		</div>
	</div>
</div>
@stop