@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Create Retriever Credential'])
<div class="wrapper-content">
    <div class="container-fluid">
    	<div class="row">
	    	<div class="col-lg-12">
	            <div class="ibox">
	                <div class="ibox-content ibox-content-settings">
	                	@include('partials.error')
				    	<form class="form-horizontal" method="post" action="{{route('retriever-credentials.store')}}" id="credentials-form">
				    		{{csrf_field()}}
							<div class="form-group">
		                        <label class="col-lg-3 control-label">URL</label>
		                        <div class="col-lg-6">
		                            <input type="text" class="form-control" name="url" value="" required>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <label class="col-lg-3 control-label">API Token</label>
		                        <div class="col-lg-6">
		                            <textarea class="form-control" name="token"  cols="30" rows="10" required></textarea>
		                        </div>
		                    </div>
		                    <div class="form-group">
								<div class="col-lg-offset-3 col-lg-1">
									<button class="btn btn-primary" name="commit" type="submit">Save</button>
								</div>
							</div>
						</form>
	                </div>
		        </div>
		    </div>
		</div>
	</div>
</div>
@stop
@section('after_scripts')
@include('assets.partials.scripts.common')
<script>
    $(document).ready(function () {
        $("#credentials-form").validate({
            rules: {
                url: {
                    required: true,
                },
                token: {
                    required: true,
                },
            },
            messages: {
                url: {
                    required: "Please enter the URL",
                },
                token: {
                    required: "Please enter the API Token",
                },
            },
            submitHandler: function (form) {
                form.submit();
            }
        });
    });
</script>
@stop

