@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Purge Assets','parentTitle'=>'Toolbox','parentUrl'=>'/toolbox'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-3">
                @include('toolbox.partials.side-nav')
            </div>
            <div class="col-lg-9">

                <div class="ibox">

                    <div class="ibox-content">

                        @include('partials.success')
                        <div class="row">
                            <div class="col-md-12">
                                <form action="/purge-assets" method="get" class="form-inline">
                                    <div class="form-group">
                                        <label></label>
                                        <input type="text" class="form-control" name="asset_tag" id="asset_tag"
                                            autocomplete="off" placeholder="Search Asset Tag #"
                                            value="{{request()->get('asset_tag')}}">
                                    </div>

                                    <div class="form-group">
                                        <label></label>
                                        <input type="text" class="form-control" name="serial_number" id="serial_number"
                                            autocomplete="off" placeholder="Search Serial #"
                                            value="{{request()->get('serial_number')}}">
                                    </div>

                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary">Search</button>
                                    </div>

                                    <div class="form-group">
                                        <a href="/purge-assets" class="btn btn-primary">Clear Search</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="ibox">
                    <div class="ibox-content">

                        <table class="footable table table-stripped table-hover nowrap" id="asset-table" data-page-size="50" data-filter=#filter>

                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>Asset Tag #</th>

                                    <th>Serial #</th>

                                    <th></th>

                                </tr>

                            </thead>

                            <tbody>

                                @forelse($assets as $asset)
                                <tr id="asset-row-{{$asset->id}}">

                                    <td>{{ $num++ }}</td>

                                    <td>{{$asset->asset_tag}}</td>

                                    <td>{{$asset->serial_no}}</td>

                                    <td>
                                        <form id="{{$asset->id}}"
                                            action="{{ route('purge-assets.destroy', $asset->id) }}" method="POST">
                                            <input type="hidden" name="_method" value="DELETE">
                                            <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                            <input type="hidden" id="asset_tag{{$asset->id}}"
                                                value="{{$asset->asset_tag}}">
                                            <a href="javascript:void(0)" class="btndelete"><i
                                                    class="icon icon-delete-forever"></i></a>
                                        </form>
                                    </td>


                                </tr>
                                @empty
                                <tr>
                                    <td colspan="2">No assets in the system.</td>
                                </tr>
                                @endforelse

                            </tbody>

                        </table>
                        <div class="pull-right">{{$assets->links()}}</div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
@include('settings.modals.confirm-delete')
@include('settings.modals.confirm-delete-all')

@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.bulk_updates'),'helpTitle'=>config('help-links.help_titles.bulk_updates')])
@endsection

@section('after_scripts')
@include('settings.partials.responsive-fixedheader')

<script>
    $(document).ready(function () {

        $(".btndelete").on("click", function () {
            var id = $(this).parent('form').attr('id');
            var assetTag = $('#asset_tag' + id).val();
            $('#confirm-delete').modal('show');
            $('#confirm-delete').attr('data-form', $(this).parent('form').attr('id'));

            $('#confirm-message').html('Are you sure you want to delete ' + assetTag + ' ? ');

        });

        $(".confirm-delete-button").on("click", function () {
            $("#" + $('#confirm-delete').attr('data-form')).submit();
        });

        $(".btnalldelete").on("click", function () {
            $('#confirm-all-delete').modal('show');
            $('#confirm-message-all').html('Are you sure you want to delete all assets ? ');
        });

        $(".confirm-delete-all-button").on("click", function () {
            $("#delete-all").submit();
        });
    });
</script>
@stop