@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'ASN Presidio API Credentials','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="ibox">

                    <div class="ibox-content">

                        @include('partials.error-message')
                        @include('partials.success')

                        <table class="table table-stripped" data-page-size="50" id="api-credential-table">

                            <thead>

                                <tr>
                                    <th>Name</th>
                                    <th>URL</th>
                                    <th>Status</th>
                                    @can('API Credentials Edit')<th>Edit</th>@endcan
                                </tr>

                            </thead>

                            <tbody>

                            @if($credentials)
                                <tr>
                                    <td>{{$credentials->api_name}}</td>
                                    <td>{{$credentials->url}}</td>
                                    <td>@if($status)
                                        <a href="#" class="btn btn-primary btn-sm" disabled>Active</a>
                                        @else
                                        <a href="#" class="btn btn-danger btn-sm" disabled>Inactive</a>
                                        @endif
                                    </td>
                                    @can('API Credentials Edit')
                                    <td><a href="{{route('asn-presidio-settings.edit', ['asn_presidio_setting' => $credentials->id])}}"><i class="icon icon-n-edit"></i></a>
                                    </td>
                                    @endcan
                                </tr>
                            @else
                                <tr>
                                    <td colspan="4">No Presidio API Credentials in the system.</td>
                                </tr>
                            @endif

                            </tbody>

                            <tfoot>

                                <tr>

                                    <td colspan="4">

                                        <ul class="pagination pull-right"></ul>

                                    </td>

                                </tr>

                            </tfoot>

                        </table>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>


@stop

@section('after_scripts')
    @include('assets.partials.scripts.common')
@stop