<script src="/js/plugins/chosen/chosen.jquery.js"></script>
<script src="/js/plugins/dataTables/datatables.min.js"></script>

<script>

	$(document).ready(function() {

		$.fn.serializeObject = function(){
		   var obj = {};
		    
		   $.each( this.serializeArray(), function(i,o){
		      var n = o.name, v = o.value;
		        
		      obj[n] = obj[n] === undefined ? v
		         : $.isArray( obj[n] ) ? obj[n].concat( v )
		         : [ obj[n], v ];
		   });
		    
		   return obj;
		};

		var table = $('.footable').DataTable({

			"processing": true,
	        "serverSide": true,
	        "ajax":{
	            "url": "{{ route('site-code-data') }}",
	            "dataType": "json",
	            "type": "POST",
	            "data": function( result ) {
	            	result.form = $('#site-code-filter-form').serializeObject();
	            }
	        },
	        "columns": [
	            { "data": "id" },
	            { "data": "code" },
	            { "data": "region" },
	            { "data": "country" },
	        ],
	        lengthMenu: [
				[ 50, 100, 200],
				[ '50', '100', '200']
			],
			columnDefs: [
	            { orderable: false, targets: 0 }
	        ],
	        'order': [[2, 'asc']],
	        "dom": '<"pull-left"i><"text-center"r><"pull-right"l><t><p>',
	        "createdRow": function( row, data, dataIndex ) {
			    $(row).attr('data-id', data.dataId);
			    $(row).attr('data-parent', data.dataParent);
			    $(row).addClass(data.dataLast ? 'last' : '');
			}, 
		});

		$(".select2").select2();

		$('.chosen-select').chosen({width: "100%"});



		$('#data_1 .input-group.date').datepicker({

			todayBtn:"linked",

			clearBtn:true,

			keyboardNavigation: false,

			forceParse: false,

			calendarWeeks: false,

			autoclose: true

		});

		$('.i-checks').iCheck({
			checkboxClass: 'icheckbox_square-green',
			radioClass: 'iradio_square-green',
		});

		$('#site-code-filter-form').submit(function (e) {

	        e.preventDefault();
	        table.draw();

		});


	});

</script>