<div class="ibox mb-0 h-100 bg-white settings">
    <div class="ibox-content">

        <div class="row d-flex-sm">
            <div class="col-sm-6 col-md-4 col-md-offset-2">
                <div class="bbox mb-0 h-100 bg-white match-height-block">
                    <h4 class="bbox-title">System Settings</h4>
                    <div class="bbox-content">
                        <ul class="list-unstyled">
                            @can('Access Levels View')
                            <li><a href="/manage-userrole">Manage User Role</a></li>
                            @endcan
                            @role('Super Admin')
                            <li><a href="/teqtivity-users">Teqtivity Users</a></li>
                            <li><a href="/system-settings/documentation">Documentation</a></li>
                            <li><a href="/system-settings/support-page">Support Page</a></li>
                            <li><a href="/teqtivity-slack-notification-app">Teqtivity Slack Notification App</a></li>
                            @endrole
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-4">
                <div class="bbox mb-0 h-100 bg-white match-height-block">
                    <h4 class="bbox-title">Hardware Assets Settings</h4>
                    <div class="bbox-content">
                        <ul class="list-unstyled">
                            @can('Attributes View')
                            <li><a href="/asset-attributes">Asset Attribute</a></li>
                            @endcan
                            @can('Asset Tab View')
                            <li><a href="/asset-tabs">Asset Tab</a></li>
                            @endcan

                            @can('Asset Type View')
                            <li><a href="/asset-type">Asset Type</a></li>
                            @endcan

                            @can('Discovery Tools Hardware Mapping')
                            <li><a href="/discovery-tools-hardware-mapping"> Discovery Tools Hardware Mapping</a></li>
                            @endcan

                            @can('Hardware Kits View')
                            <li><a href="/hardware-kits"> Hardware Kits </a></li>
                            @endcan

                            @can('Hardware Standards & Technical Specs View')
                            <li><a href="/manufacturer">Manufacturer</a></li>
                            <li><a href="/hardware-standard">Hardware Standard</a></li>
                            @endcan

                            @can('Hardware Standards & Technical Specs View')
                            <li><a href="/technical-specs">Technical Specs</a></li>
                            @endcan

                            @can('Mobile Carrier View')
                            <li><a href="/carrier">Mobile Carrier</a></li>
                            @endcan

                            @can('Vendor Manage')
                            <li><a href="{{route('vendor-listing')}}">Vendors</a></li>
                            <li><a href="{{ route('vendor-categories.index') }}">Vendor Categories</a></li>
                            @endcan
                            <li><a href="/operating-system-compliance">Operating System Compliance</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="row d-flex-sm mt-2-sm">
            <div class="col-md-4 col-sm-6 col-md-offset-2">
                <div class="bbox mb-0 h-100 bg-white match-height-block">
                    <h4 class="bbox-title">Location Settings</h4>
                    <div class="bbox-content">
                        <ul class="list-unstyled">
                            @can('Location Type View')
                            <li><a href="/location-type">Location Type</a></li>
                            @endcan
                            @can('Region View')
                            <li><a href="/region">Region</a></li>
                            @endcan
                            @can('State View')
                            <li><a href="/state">State</a></li>
                            @endcan
                            @can('Site Code View')
                            <li><a href="/site-code">Site Code</a></li>
                            @endcan
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-4">
                <div class="bbox mb-0 h-100 bg-white match-height-block">
                    <h4 class="bbox-title">Software Assets Settings</h4>
                    <div class="bbox-content">
                        <ul class="list-unstyled">
                            @can('Software Assets Category View')
                            <li><a href="/software-assets-categories">Categories</a></li>
                            @endcan
                            @can('Software Assets Manufacturer Manage')
                            <li><a href="/software-assets-manufacturers">Manufacturers</a></li>
                            @endcan
                            @can('Software Assets Subscription Manage')
                            <li><a href="/software-assets-subscription">Subscription Types</a></li>
                            @endcan
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="row d-flex-sm mt-2-sm">
            <div class="col-md-4 col-sm-6 col-md-offset-2">
                <div class="bbox mb-0 h-100 bg-white match-height-block">
                    <h4 class="bbox-title">Integrations</h4>
                    <div class="bbox-content">
                        <ul class="list-unstyled">
                            @can('API Credentials View')
                            <li><a href="{{route('presidio-settings')}}"> ASN Presidio </a></li>
                            {{-- <li><a href="{{ route('aws-cloud-assets.index') }}">AWS Cloud Assets</a></li> --}}
                            <!-- <li><a href="/azure-directory">Azure - Directory</a></li> -->
                            <li><a href="/azure-sso">Azure - SSO</a></li>
                            <li><a href="/dropbox">Dropbox</a></li>
                            <li><a href="/hibob">HiBob</a></li>
                            <li><a href="/slack">Slack</a></li>
                            <li><a href="/zoom">Zoom</a></li>
                            <li><a href="/crowdstrike">Crowdstrike</a></li>
                            <li><a href="/fedex-tracking-api">FedEx</a></li>
                            <li><a href="/freshservice">Freshservice</a></li>
                            {{--<li><a href="/chrome-devices">Google Workspace - Chrome Devices</a></li>--}}
                            {{--<li><a href="/gsuite-locations">Google Workspace - Location Resources</a></li>--}}
                            {{--<li><a href="/google-directory">Google Workspace - Google Directory</a></li>--}}
                            {{-- <li><a href="/jamf">Jamf</a></li> --}}
                            <li><a href="/jira-credentials">Jira Service Desk</a></li>
                            {{-- <li><a href="/jumpcloud">JumpCloud</a></li> --}}
                            {{-- <li><a href="/kandji">Kandji</a></li> --}}
                            {{-- <li><a href="/mobile-iron">MobileIron</a></li> --}}
                            <li><a href="/intune">Microsoft Intune</a></li>
                            {{-- <li><a href="/okta-directory">Okta - Directory</a></li> --}}
                            {{--<li><a href="/okta-sso">Okta - SSO</a></li>--}}
                            {{-- <li><a href="/okta-scim">Okta - SCIM</a></li> --}}
                            {{-- <li><a href="/retriever-credentials">Retriever</a></li> --}}
                            {{-- <li><a href="/revivn"> Revivn </a></li> --}}
                            {{-- <li><a href="/slack-notification-credentials"> Slack Notification Credentials</a></li> --}}
                            <li><a href="/slack-notifications"> Slack Notifications</a></li>
                            <li><a href="/spoke">Spoke</a></li>
                            {{--<li><a href="/asn-shi-api-settings">SHI</a></li> --}}
                            <li><a href="/ups-tracking">UPS</a></li>
                            {{-- <li><a href="/workspace-one">Workspace ONE</a></li> --}}
                            {{-- <li><a href="/zendesk">Zendesk</a></li> --}}
                            <li><a href="{{ route('zoom-hardware.index') }}"> Zoom Hardware </a></li>
                            @endcan
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-md-4 col-sm-6">
                <div class="bbox mb-0 h-100 bg-white match-height-block">
                    <h4 class="bbox-title">History</h4>
                    <div class="bbox-content">
                        <ul class="list-unstyled">
                            @can('API Users View')
                            <li><a href="{{ route('api-blocked-ips.index') }}">API History - Blocked IP Addresses</a></li>
                            @endcan
                            <li><a href="{{ route('api-request-history.index') }}">API Request History</a></li>

                            @can('ASN History')
                            <li><a href="/asn-history">ASN History</a></li>
                            @endcan
                            @can('Failed Ticket Logs View')
                            <li><a href="/failed-tickets">Failed Ticket History</a></li>
                            @endcan
                            <li><a href="{{ route('location-history.index') }}">Location History</a></li>
                            @can('Purge Assets')
                            <li><a href="{{ route('purged-assets-history.index') }}">Purged Assets History</a></li>
                            @endcan
                            <li><a href="{{ route('software-asset-history.index') }}">Software Asset History</a></li>
                            <li><a href="{{ route('system-history.index') }}">System History</a></li>
                            <li><a href="{{ route('user-history.index') }}">User History</a></li>
                            <li><a href="{{ route('user-role-change-history.index') }}">User Role Change History</a></li>
                            @can('User Login History')
                            <li><a href="{{ route('user-login-history.index') }}">User Login History</a></li>
                            @endcan
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@section('after_scripts')
<script src="/js/plugins/jasny/jasny-bootstrap.min.js"></script>
<script src="/js/plugins/match-height/jquery.matchHeight.min.js"></script>
<script>

    $(document).ready(function () {

        $('.match-height-block').matchHeight({ property: 'height' });
    })
</script>
@endsection
