<link href="/css/plugins/dropzone/basic.css" rel="stylesheet">
<link href="/css/plugins/dropzone/dropzone.css" rel="stylesheet">
<script src="/js/plugins/dropzone/dropzone.js"></script>
<script>
    var currentFile = null;
    Dropzone.options.dropzoneForm = {
        paramName: "file", // The name that will be used to transfer the file
        maxFilesize: 10, // MB
        addRemoveLinks: true,
        thumbnailWidth: 175,
        thumbnailHeight: 175,
        acceptedFiles: '.csv,.xlsx',
        dictDefaultMessage: "<strong>Drop file here or click to upload. </strong>",
        dictResponseError: 'Something went wrong. Try again later!',
        dictInvalidFileType: 'Please select a CSV or XLSX file',
        init: function () {
            var myDropzone = this;
            var el = $(myDropzone.element).closest('.form-container');
            var countEl = $(el).find('.total-count');
            var messageEl = $(el).find('.message-div');
            var errorEl = $(el).find('.error-div');

            // Update selector to match your button
            $(el).find("#button").click(function (e) {
                e.preventDefault();
                myDropzone.processQueue();
            });

            myDropzone.on('sending', function (file, xhr, formData) {
                messageEl.html('');
            });
            myDropzone.on("success", function (files, response) {
                // Gets triggered when the files have successfully been sent.
                var count = 0;
                $(".bulk-upload-save-button").attr('disabled',true);
                if ($('#tblview tbody tr').length !== 0) {
                    count = $('#tblview tbody tr').length;
                }
                count = parseInt(count) + parseInt(response.countVal)
                $('tbody').append(response.data);
                messageEl.append(response.errors);
                messageEl.append(response.duplicate_errors);
                messageEl.append(response.statusChange_errors);
                messageEl.append(response.locationChangeErrors);
                $('#asset_count').text(count);
                $(".bulk-upload-save-button").attr('disabled',true);
                $(".alert-success").alert('close');
                if(!isNaN(count) && count > 0){
                    $(".bulk-upload-save-button").attr('disabled',false);
                }
            });
            myDropzone.on("error", function (files, response) {
                // Gets triggered when there was an error sending the files.

                $(".alert-success").alert('close');
                errorEl.html('<div class="alert alert-danger" role="alert">' + response + '</div>');
            });
            myDropzone.on("addedfile", function (file) {
                var count = myDropzone.files.length;
                countEl.html('<a>Total Selected Files <span class="badge">' + count + '</span></a>');
            });
            myDropzone.on("removedfile", function (file) {
                var count = myDropzone.files.length;
                countEl.html('<a>Total Selected Files <span class="badge">' + (count) + '</span></a>');
                $(".alert-danger").alert('close');
                messageEl.html('');
                errorEl.html('');
            });


        }
    };

    Dropzone.options.dropzoneSpecialForm = {
        paramName: "file", // The name that will be used to transfer the file
        maxFilesize: 10, // MB
        addRemoveLinks: true,
        thumbnailWidth: 175,
        thumbnailHeight: 175,
        acceptedFiles: '.csv,.xlsx',
        dictDefaultMessage: "<strong>Drop file here or click to upload. </strong>",
        dictResponseError: 'Something went wrong. Try again later!',
        dictInvalidFileType: 'Please select a CSV or xlsx file',
        init: function () {
            var myDropzone = this;
            var el = $(myDropzone.element).closest('.form-container');
            var countEl = $(el).find('.total-count');
            var messageEl = $(el).find('.message-div');
            var errorEl = $(el).find('.error-div');

            $(el).find("#button").click(function (e) {
                e.preventDefault();
                myDropzone.processQueue();
            });

            myDropzone.on('sending', function (file, xhr, formData) {
                messageEl.html('');
            });
            myDropzone.on("success", function (files, response) {
                messageEl.append(response.message);
                messageEl.append(response.errors);
            });
            myDropzone.on("error", function (files, response) {
                // Gets triggered when there was an error sending the files.
                messageEl.html('<div class="alert alert-danger" role="alert">' + response + '</div>');
            });
            myDropzone.on("addedfile", function (file) {
                var count = myDropzone.files.length;
                countEl.html('<a>Total Selected Files <span class="badge">' + count + '</span></a>');
            });
            myDropzone.on("removedfile", function (file) {
                var count = myDropzone.files.length;
                countEl.html('<a>Total Selected Files <span class="badge">' + (count) + '</span></a>');
                messageEl.html('');
                errorEl.html('');
            });
        }
    };
</script>
<style>
    /* bulk uploads drag n drop*/
    .dropzone .dz-preview .dz-image {
        width: 175px;
        height: 175px;
    }

    .dropzone .dz-preview {
        width: 175px;
    }

    .ibox-content .file-drag {
        display: flex;
        flex-wrap: wrap;
        border-style: dotted;
        justify-content: center;
    }

    .bottom-panel button {
        width: 115px;
    }

    .bottom-panel {
        display: flex;
        margin-bottom: 15px;
    }

    .total-count {
        margin-right: 30px;
    }

    .total-count:empty {
        margin: 0;
    }

    .total-count a {
        display: flex;
        align-items: center;
        height: 100%;
    }
</style>