@extends('layouts.settings')
@section('content')
    @include('partials.breadcrumb', ['breadcrumbTitle' => 'Operating System Compliance Settings','parentTitle'=>'Settings','parentUrl'=>'/settings'])
    <div class="wrapper-content">
        <div class="container-fluid">
                    
                @include('partials.success')
                @include('partials.error')
             
                        <form method="post" id="" action="/operating-system-compliance"
                            enctype="multipart/form-data">
                            {{ csrf_field() }}
                            @foreach ($data as $title => $value)
                                <div class="ibox">
                                    <div class="ibox-title">
                                        <h3>{{ $title =='apple_mobile'? 'Apple Mobile' :ucfirst($title) }}</h3>
                                    </div>

                                    <div class="collapse in" id="collapseFilter">
                                        <div class="ibox-content">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label">OS Platform </label>
                                                        <input type="text" name="{{ $title }}[os_platform]" value="{{$value['platform'] ?? ''}}" class="form-control">
                                                    </div>
                                                </div>

                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label">OS Version</label>
                                                        <input type="text" name="{{ $title }}[os_version]" value="{{$value['version'] ?? ''}}" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                            <button class="btn btn-primary saveSettings" type="submit">Save</button>
                        </form>
                    </div>
                </div>

@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.operating_system_compliance'),'helpTitle'=>config('help-links.help_titles.operating_system_compliance')])
@endsection

@section('after_scripts')
    <script src="/js/plugins/chosen/chosen.jquery.js"></script>
    <script src="/js/plugins/chosen/chosen.ajaxaddition.jquery.js"></script>
    <script>
        $(document).ready(function() {
            $(".chosen-select").chosen({
                width: "100%"
            });
            $('.saveSettings').click(function() {
                if (!confirm('Are you sure you want to update the settings ?')) {
                    return false;
                }
            });
        });
    </script>
@endsection
