@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Okta SCIM Configuration','parentTitle'=>'Settings','parentUrl'=>'/settings'])

<div class="wrapper-content">
	<div class="container-fluid">

		<div class="ibox">
			<div class="ibox-content ibox-content-settings">

                @include('partials.success')
                @include('partials.error')
                <p>
                    Configure Single Sign-On (SSO) before enabling SCIM (System for Cross-domain Identity Management) to ensure smooth user management and data synchronization between your application and the identity provider. <br>
                    SSO allows seamless authentication across multiple systems, while SCIM automates user management processes. Prioritizing SSO setup before enabling SCIM optimizes the user experience.
                </p>

                <div class="p-10" style="padding-top: 20px;clear: both;">
                    <label class="toggle-switch">
                        <input type="checkbox" id="toggleButton" @if($credential->integration_status == 1) checked @endif>
                        <span class="toggle-slider"></span>
                        </label>
                        <span style="display: inline-block;float: left;padding-right: 15px;font-size: 15px;font-weight: 600;">Enable SCIM for Okta<small style="font-size: 65%;display:block;">Add the Base URL and SCIM token to Okta.</small></span>
                </div>


                <div class="row" style="clear: both;">


                    <div class="col-md-6">
                        <div style="padding-top: 20px; clear: both;">
                            <h3>Base URL</h3>
                            <p>You need the base URL to configure your Identity Provider.</p>
                        </div>

                        <div class="row">
                            <div class="col-md-10">
                                <div class="alert alert-success">
                                    <h5>Base URL</h5>
                                    <p id="base_url">{{ $credential->url }}</p>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <button @if(!$credential->integration_status) disabled @endif style="margin-top: 20px;" class="copy-text btn btn-primary" data-id="base_url" name="commit">Copy <i class="icon icon-copy-2"></i></button>
                            </div>
                        </div>

                        <div style="padding-top: 20px; clear: both;">
                            <h3>SCIM token</h3>
                            <p>Generate a token to use in your Identity Provider configuration.</p>
                        </div>

                        <button  @if(!$credential->integration_status) disabled @endif style="margin-top: 20px; margin-left:10%; margin-bottom:20px;" data-loading-text="Generating Token" class="btn btn-primary" id="generate-token" name="commit" id="generate_token">Generate Token </button>

                        <div class="row">
                            <div class="col-md-10">
                                <div class="alert alert-success">
                                    <h5>Token</h5>
                                    <p id="secure_token">{{ $credential->key ?? '' }}</p>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <button  @if(!$credential->integration_status) disabled @endif style="margin-top: 20px;" class="copy-text btn btn-primary" data-id="secure_token" name="commit">Copy <i class="icon icon-copy-2"></i></button>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div style="padding-top: 20px; clear: both;">
                            <h3>Default User Role</h3>
                            <p>You need to specify a role in Teqtivity to assign to a user when they are removed from a group in Okta.</p>
                        </div>
                        <p class="text-danger" id="active_msg" style="display:none;">Select a default role before enabling SCIM </p>
                        <form id="update_form" class="form-horizontal" method="post" action="{{route('okta-scim.update', [$credential->id])}}">

                            {{csrf_field()}}

                            <input type="hidden" name="_method" value="PUT">
                            <input type="hidden" id="integration_status" name="integration_status" value="{{ $credential->integration_status }}">

                            <div class="form-group">
                                <label class="col-lg-2 control-label">Select Role</label>
                                <div class="col-lg-6">
                                    <select id="user_type_id" name="user_type_id" class="form-control select2"
                                                required="required">
                                                <option value="">--Select--</option>
                                                @foreach($userRoles as $type)
                                                <option value="{{$type->id}}" @if($credential->role_id == $type->id) selected @endif>{{$type->name}}
                                                </option>
                                                @endforeach
                                </select>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>


            </div>
		</div>
	</div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection


@section('after_scripts')
<script>
    $(document).ready(function() {
        $('#generate-token').click(function() {

            // Cache the button element
            var $button = $(this);

            $button.button('loading');

            $.ajax({
                url: '/generate-secure-token', // Replace with your actual controller endpoint
                type: 'POST',
                dataType: 'json',
                success: function(response) {
                    // Handle the JSON response
                    var token = response.token;
                    $("#secure_token").text(token);
                    $button.button('reset');
                },
                error: function(xhr, status, error) {
                    // Handle the error
                    console.log('Error:', error);
                    $button.button('reset');
                }
            });
        });


        $(".copy-text").on('click', function(e){
            var id = $(this).attr('data-id');
            var temp = $("<input>");
            $("body").append(temp);
            temp.val($('#'+id).text()).select();
            document.execCommand("copy");
            temp.remove();
        });

        $('#toggleButton').change(function() {
            if ($(this).is(':checked')) {
                $("#integration_status").val(1);
                if($("#user_type_id").val() == "")
                {
                    $("#active_msg").show();
                    return false;
                }
            } else {
                $("#integration_status").val(0);
            }

            $("#update_form").submit();
        });

        $('#user_type_id').change(function() {
            if ($("#toggleButton").is(':checked') && $(this).val() != "") {
                $("#update_form").submit();
            }
        });
    });
</script>
@stop