@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Okta Directory
Credential','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        
        <div class="ibox">
            
            <div class="ibox-content">
                
                @include('partials.error-message')
                @include('partials.success')
                @include('partials.sync-messages')
                
                <table class="table footable table-stripped table-hover" data-page-size="50" data-filter=#filter id="api-credential-table">

                    <thead>

                        <tr>
                            <th>Name</th>
                            <th>Edit</th>
                            <th>Sync</th>
                        </tr>

                    </thead>

                    <tbody>

                        @if($credentials)
                        <tr>
                            <td>{{$credentials->api_name}}</td>
                            <td>
                                @can('API Credentials Edit')
                                <a href="{{route('okta-directory.edit', ['okta_directory' => $credentials->id])}}"><i class="icon icon-n-edit"></i></a>
                                @endcan
                            </td>
                            <td>
                                <button class="btn btn-primary btn-sm" id="okta-sync">Manual Sync</button>
                                <button class="btn btn-primary btn-sm" id="okta-sync2" disabled
                                    style="display: none;"><i class="icon icon-explore-user"></i></button>
                            </td>
                        </tr>
                        @else
                        <tr>
                            <td colspan="3">No Okta Directory Credentials in the system.</td>
                        </tr>
                        @endif

                    </tbody>

                    <tfoot>

                        <tr>

                            <td colspan="3">

                                <ul class="pagination pull-right"></ul>

                            </td>

                        </tr>

                    </tfoot>

                </table>
          
        </div>     
    </div>
    
</div>


@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection


@section('after_scripts')
@include('settings.partials.responsive-fixedheader')
@include('assets.partials.scripts.common')
@stop