@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Create Okta Directory Credential','parentTitle'=>'Settings','parentUrl'=>'/settings','parentSubTitle' => 'Okta Directory Credential','parentSubUrl'=>'/okta-directory'])

<div class="wrapper-content">

    <div class="container-fluid">
		<div class="ibox">

			@include('partials.error')

			<div class="ibox-content ibox-content-settings">

				<form class="form-horizontal" method="post" action="{{route('okta-directory.store')}}">

					{{csrf_field()}}


					<div class="form-group">
						<label class="col-lg-3 control-label">Issuer URI</label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="issuer_url" value="{{ old('issuer_url') }}" required>
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">API Token</label>
						<div class="col-lg-6">
							<input type="password" class="form-control" name="api_token" value="{{ old('api_token') }}" required>
						</div>
					</div>
					

					<div class="form-group">
						<div class="col-lg-offset-3 col-lg-1">
							<button class="btn btn-primary" name="commit" type="submit">Save</button>
						</div>
					</div>

				</form>
			</div>
		</div>
	</div>

</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection


@section('after_scripts')
    @include('assets.partials.scripts.common')
@stop