@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Carrier','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        <div class="ibox">
            
            <div class="ibox-content">
                
                @can('Mobile Carrier Edit')
                <p><a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html"
                    data-target="#addCarrier">Add New</a></p>
                    
                    @include('settings.partials.success-message')
                    @include('settings.partials.delete-message')
                    @endcan
                    
                    <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                    id="carrier-table">
                    
                    <thead>
                        
                        <tr>
                            <th style="display: none;"></th>
                            <th>#</th>
                            <th>Name</th>
                            <th>Country</th>
                            
                        </tr>
                        
                    </thead>
                    
                    <tbody>
                        
                        @foreach($carriers as $carrier)
                        <tr>
                            <td style="display: none;">{{$carrier->id}}</td>
                            
                            <td>{{$loop->iteration}}</td>
                            
                            <td >{{$carrier->name}}</td>
                            
                            <td >{{optional($carrier->country)->name}}</td>
                            
                        </tr>
                        @endforeach
                        
                    </tbody>
                    
                    <tfoot>
                        
                        <tr>
                            
                            <td colspan="3">
                                
                                <ul class="pagination pull-right"></ul>
                                
                            </td>
                            
                        </tr>
                        
                    </tfoot>
                    
                </table>
                
            </div>
            
        </div>
        
    </div>
    
</div>


<div class="modal inmodal" id="addCarrier" tabindex="-1" role="dialog">
    
    <div class="modal-dialog">
        
        <div class="modal-content animated fadeIn">
            
            <div class="modal-header">
                
                <button type="button" class="close" data-dismiss="modal"><span>×</span><span
                    class="sr-only">Close</span></button>
                    
                    <h4 class="modal-title">Add New Mobile Carrier</h4>
                    
                </div>
                
                <div class="modal-body">
                    
                    @include('partials.error')
                    
                    <form class="form-horizontal" action="" method="post" id="carrier-form">
                        
                        {{csrf_field()}}
                        
                        <div class="form-group">
                            
                            <label class="col-lg-4 control-label">Name</label>
                            
                            <div class="col-lg-8">
                                
                                <input type="text" class="form-control" name="carrier" value="{{old('carrier')}}" required>
                                
                            </div>
                            
                        </div>
                        <div class="form-group">
                            
                            <label class="col-lg-4 control-label">Country</label>
                            
                            <div class="col-lg-8">
                                @include('partials.dropdowns.country')
                                
                            </div>
                            
                        </div>
                        
                    </form>
                    
                </div>
                
                <div class="modal-footer">
                    
                    <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>
                    
                    <button type="button" class="btn btn-primary" id="submit">Save</button>
                    
                </div>
                
            </div>
            
        </div>
        
    </div>
    
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.mobile_carrier'),'helpTitle'=>config('help-links.help_titles.mobile_carrier')])
@endsection

@section('after_scripts')

@include('settings.mobile-carrier.mobile-carrier-script')

@stop