@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' =>
'Manufacturer','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        
        <div class="ibox">
            <div class="ibox-title">
                
                <div class="ibox-tools">
                    
                    <a href="#" id="export-csv" class="btn btn-primary">Export to CSV</a>
                    <a href="#" class="btn btn-primary pull-right" data-toggle="modal" href="remote.html"
                    data-target="#addManufacturer">Add New</a>
                </div>
                
            </div>
            
            <div class="ibox-content">
                
                <p></p>
                
                @include('settings.partials.success-message')
                @include('settings.partials.delete-message')
                
                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                id="manufacturer-table">
                
                <thead>
                    
                    <tr >
                        <th style="display: none;"></th>
                        <th>#</th>
                        <th>Name</th>
                        <th># of Assets</th>
                    </tr>
                    
                </thead>
                
                <tbody>
                    
                    @foreach($manufacturers as $manufacturer)
                    <tr>
                        <td style="display: none;">{{$manufacturer->id}}</td>
                        
                        <td>{{$loop->iteration}}</td>
                        
                        <td >{{$manufacturer->name}}</td>
                        
                        <td >{{
                            
                            App\Models\Asset::whereHas('MakeAndModel', function($query) use ($manufacturer){
                                $query->where('manufacturer_id', $manufacturer->id);
                            })->count()
                        }}
                    </td>
                </tr>
                @endforeach
                
            </tbody>
            
            <tfoot>
                
                <tr>
                    
                    <td colspan="3">
                        
                        <ul class="pagination pull-right"></ul>
                        
                    </td>
                    
                </tr>
                
            </tfoot>
            
        </table>
        
    </div>
    
</div>

</div>

</div>


<div class="modal inmodal" id="addManufacturer" tabindex="-1" role="dialog">
    
    <div class="modal-dialog">
        
        <div class="modal-content animated fadeIn">
            
            <div class="modal-header">
                
                <button type="button" class="close" data-dismiss="modal"><span>×</span><span
                    class="sr-only">Close</span></button>
                    
                    <h4 class="modal-title">Add New Manufacturer</h4>
                    
                </div>
                
                <div class="modal-body">
                    
                    @include('partials.error')
                    
                    <form class="form-horizontal" action="" method="post" id="manufacturer-form">
                        
                        {{csrf_field()}}
                        
                        <div class="form-group">
                            
                            <label class="col-lg-4 control-label">Name</label>
                            
                            <div class="col-lg-8">
                                
                                <input type="text" class="form-control" name="manufacturer" value="{{old('manufacturer')}}"
                                required>
                                
                            </div>
                            
                        </div>
                        
                    </form>
                    
                </div>
                
                <div class="modal-footer">
                    
                    <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>
                    
                    <button type="button" class="btn btn-primary" id="submit">Save</button>
                    
                </div>
                
            </div>
            
        </div>
        
</div>

@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.manufacturer'),'helpTitle'=>config('help-links.help_titles.manufacturer')])
@endsection

@section('after_scripts')

@include('settings.manufacturer.manufacturer-script')

@stop