<script src="/js/plugins/dataTables/datatables.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/plugins/dataTables/dataTables.fixedHeader.min.js"></script>
<script src="/js/plugins/tabledit/tabledit.js"></script>
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>

<script>
    @if ($errors -> count() > 0)
        $("#addManufacturer").modal({
            show: true
        });
    @endif

    $(document).ready(function () {
        $('.modal').on('show.bs.modal', function (e) {
            $(".alert-danger").hide();
        });

        $('.footable').DataTable({
            scrollCollapse: false,
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            fixedHeader: {
                header: true,
            },
            "order": [[2, "asc"]],
            "bFilter": false,
            "bLengthChange": false,
            "bInfo": false,
        })
        $('#submit').click(function () {
            $('#manufacturer-form').submit();
        });

        @if($manufacturers->count() > 0)
        $('#manufacturer-table').Tabledit({
            url: '/manufacturer-ajax',
            columns: {
                identifier: [0, 'manufacturer_id'],
                editable: [
                    [2, 'name']
                ]
            },
            warningClass: 'success',
            mutedClass: 'danger',
            onSuccess: function (data) {
                $('.ajax-messages').hide();
                if (data == 'success') {
                    $('#success').show();
                    $('#success p').text("Manufacturer updated successfully.");
                } else if (data == 'Deleted Successfully') {
                    $('#success').show();
                    $('#success p').text("Manufacturer deleted successfully.");
                } else if (data == 'error') {
                    $('#error').show();
                    $('#error p').text("This manufacturer cannot be deleted as it has hardware standards associated with it.");
                }
                $('html, body').animate({
                    scrollTop: $("#error").offset().top
                }, 1000);
            },
            restoreButton: false
        });
        @endif

        $('#export-csv').on('click', function (e) {
            e.preventDefault();
            $('.ajax-loader').show();
            $.ajax({
                type: "POST",
                url: "/manufacturer/manufacturer-export",
                // data: $('#search-form').serializeObject(),
                dataType: 'text',
                success: function (result) {
                    var blob = new Blob([result]);
                    if (window.navigator.msSaveOrOpenBlob)  // IE hack; see http://msdn.microsoft.com/en-us/library/ie/hh779016.aspx
                        window.navigator.msSaveBlob(blob, "manufacturer.csv");
                    else {
                        var a = window.document.createElement("a");
                        a.href = window.URL.createObjectURL(blob, { type: "text/plain" });
                        a.download = "manufacturer.csv";
                        document.body.appendChild(a);
                        a.click();  // IE: "Access is denied"; see: https://connect.microsoft.com/IE/feedback/details/797361/ie-10-treats-blob-url-as-cross-origin-and-denies-access
                        document.body.removeChild(a);
                    }
                    $('.ajax-loader').hide();
                }
            })
        });


    });
</script>