@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Manage User Role','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">

        <div class="ibox">

            <div class="ibox-content">

                @can('Access Levels Edit')
                <p><a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html" data-target="#addAccessRole">Add New Role</a></p>
                <!--<div class="col-xs-6 col-sm-3 col-md-2"><a href="#"
                    class="btn btn-w-m btn-primary pull-right-sm" data-toggle="modal" href="remote.html"
                    data-target="#addAccessLevel">Add New Permission</a></div>

                    <div class="col-xs-6 col-sm-3 col-md-2"><a href="#"
                        class="btn btn-w-m btn-primary pull-right-sm" data-toggle="modal" href="remote.html"
                        data-target="#addPermissionGroup">Add Permission Group</a></div> -->


                        @endcan

                        <form action="" method="post">

                            @include('partials.success')

                            <table class="footable  table table-stripped table-hover" data-page-size="50" data-filter=#filter
                            id="hardware-standard-table">

                            <thead>

                                <tr>

                                    <th>#</th>

                                    <th>Accessibility</th>

                                    @foreach($roles as $role)
                                    <th>
                                        {{$role->name}}
                                    </th>
                                    @endforeach

                                </tr>

                            </thead>

                            <tbody>
                                @foreach($permissionCategories as $category)

                                <tr>
                                    <td colspan="{{$roles->count() + 2}}">
                                        <h3>{{$category->name}}</h3>
                                    </td>

                                </tr>





                                @forelse($category->permissions as $permission)

                                <tr>

                                    <td>{{$loop->iteration}}</td>

                                    <td>{{$permission->name}}</td>

                                    @foreach($roles as $role)

                                    <td>
                                        <?php try{ ?>

                                            <span>
                                                <input type="checkbox" name="{{$role->name}}-{{$permission->name}}"
                                                {{$role->hasPermissionTo($permission) ? 'checked' : '' }}
                                                {{$role->name == "Administrator" ? 'disabled' : ''}}>
                                            </span>
                                            <?php }catch(\Exception $e){ ?>


                                                <?php } ?>
                                            </td>

                                            @endforeach

                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="{{ $roles->count() + 2 }}">No Permissions Added For this Category
                                            </td>
                                        </tr>

                                        @endforelse
                                        @endforeach

                                        @can('Access Levels Edit')
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            @foreach($roles as $role)
                                            <td>
                                                @if ($role->name != "Administrator")
                                                <button type="button" class="delete btn btn-link"
                                                title="Deactivate Role"><span
                                                class="icon icon-delete-forever"></span></button>
                                                <button type="button" class="tabledit-confirm-button btn btn-sm btn-danger"
                                                style="display: none;" data-role="{{$role->id}}">Confirm</button>
                                                @endif
                                            </td>
                                            @endforeach
                                        </tr>
                                        @endcan


                                    </tbody>

                                    <tfoot>

                                        <tr>

                                            <td colspan="{{ $roles->count()+2 }}">

                                                <ul class="pagination pull-right"></ul>
                                                @include('settings.partials.delete-message')

                                            </td>

                                        </tr>

                                    </tfoot>

                                </table>

                                {{csrf_field()}}
                                @can('Access Levels Edit')
                                <button class="btn btn-primary" type="submit">Save</button>
                                @endcan

                            </form>

                        </div>

                    </div>

                </div>

            </div>

            @stop

            @section('help-links')
            @include('help.help-links',['helpLink'=>config('help-links.help_links.system_settings'),'helpTitle'=>config('help-links.help_titles.system_settings')])
            @endsection

            @section('after_scripts')
            <link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
            @include('settings.modals.add-new-access-role')
            @include('settings.modals.add-new-access-level')
            @include('settings.modals.add-new-permission-group')

            <script>

                @if ($errors -> count() > 0)
                $("#addAccessRole").modal({ show: true });
                @endif

                $(document).ready(function () {

                    $('.modal').on('show.bs.modal', function (e) {
                        $(".alert-danger").hide();
                    });

                    $('#submit').click(function () {
                        $('#access-role-form').submit();
                    });

                    $('#submit_level').click(function () {
                        $('#access-level-form').submit();
                    });

                    $('.delete').click(function () {
                        $(this).next().toggle();
                    })

                    $('.tabledit-confirm-button').click(function () {
                        var id = $(this).attr('data-role');
                        $.ajax({
                            type: "POST",
                            url: "/access-levels-deactivate",
                            data: { role: id },
                            success: function (result) {
                                if (result == 'error') {
                                    $('#error').show();
                                    $('#error p').text("This Access Level cannot be made inactive as it has users associated with it.");
                                }
                                else {
                                    location.reload();
                                }
                            }
                        })
                    })

                });

            </script>

            @endsection
