@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Location
Type','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        
        <div class="ibox">
            
            <div class="ibox-content">
                
                @can('Location Type Edit')
                <p><a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html"
                    data-target="#addLocationType">Add New</a></p>
                    @include('settings.partials.success-message')
                    @include('settings.partials.delete-message')
                    @endcan
                    
                    <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter
                    id="location-type-table">
                    
                    <thead>
                        
                        <tr>
                            <th style="display: none;"></th>
                            <th>#</th>
                            <th>Name</th>
                        </tr>
                            
                    </thead>
                        
                    <tbody>
                            
                            @foreach($locationTypes as $locationType)
                            <tr>
                                <td style="display: none;">{{$locationType->id}}</td>
                                
                                <td>{{$loop->iteration}}</td>
                                
                                <td >{{$locationType->location_type_name}}</td>
                                
                            </tr>
                            @endforeach
                            
                        </tbody>
                        
                        <tfoot>
                                
                                <tr>
                                    
                                    <td colspan="3">
                                        
                                        <ul class="pagination pull-right"></ul>
                                        
                                    </td>
                                    
                                </tr>
                                
                            </tfoot>
                            
                        </table>
                        
                    </div>
                    
                </div>
                
            </div>
            
        </div>
        
        
        <div class="modal inmodal" id="addLocationType" tabindex="-1" role="dialog">
            
            <div class="modal-dialog">
                
                <div class="modal-content animated fadeIn">
                    
                    <div class="modal-header">
                        
                        <button type="button" class="close" data-dismiss="modal"><span>×</span><span
                            class="sr-only">Close</span></button>
                            
                            <h4 class="modal-title">Add New Location Type</h4>
                            
                        </div>
                        
                        <div class="modal-body">
                            
                            @include('partials.error')
                            
                            <form class="form-horizontal" action="" method="post" id="location-type-form">
                                
                                {{csrf_field()}}
                                
                                <div class="form-group">
                                    
                                    <label class="col-lg-4 control-label">Name</label>
                                    
                                    <div class="col-lg-8">
                                        
                                        <input type="text" class="form-control" name="location_type"
                                        value="{{old('location_type')}}" required>
                                        
                                    </div>
                                    
                                </div>
                                
                            </form>
                            
                        </div>
                        
                        <div class="modal-footer">
                            
                            <button type="button" class="btn btn-link" data-dismiss="modal">Cancel</button>
                            
                            <button type="button" class="btn btn-primary" id="submit">Save</button>
                            
                        </div>
                        
                    </div>
                    
                </div>
                
            </div>
            
            
            @stop

            @section('help-links')
            @include('help.help-links',['helpLink'=>config('help-links.help_links.location_type'),'helpTitle'=>config('help-links.help_titles.location_type')])
            @endsection
            
            @section('after_scripts')
            
            @include('settings.location-type.location-type-script')
            
            @stop