<script src="/js/plugins/dataTables/datatables.min.js"></script>
<link href="/css/plugins/dataTables/fixedHeader.dataTables.min.css" rel="stylesheet">
<script src="/js/plugins/dataTables/dataTables.fixedHeader.min.js"></script>
<script src="/js/plugins/tabledit/tabledit.js"></script>
<script src="/js/plugins/jquery-validation/jquery.validate.min.js"></script>

<script>

    @if ($errors -> count() > 0)
        $("#addLocationType").modal({ show: true });
    @endif

    $(document).ready(function () {

        $('.modal').on('show.bs.modal', function (e) {
            $(".alert-danger").hide();
        });

        $('.footable').DataTable({
            scrollCollapse: false,
            lengthMenu: [
                [50, 100, 200],
                ['50', '100', '200']
            ],
            fixedHeader: {
                header: true,
            },
            "order": [[2, "asc"]],
            "bFilter": false,
            "bLengthChange": false,
            "bInfo": false,
        })

        $('#submit').click(function () {
            $('#location-type-form').submit();
        });

        @can('Location Type Edit')
        @if($locationTypes->count() > 0)
        $('#location-type-table').Tabledit({
            url: '/location-type-ajax',
            columns: {
                identifier: [0, 'location_type_id'],
                editable: [[2, 'name'], [3, 'row', 'select', '{"1": "Yes", "0": "No"}']]
            },
            warningClass: 'success',
            mutedClass: 'danger',
            onSuccess: function (data) {

                $('.ajax-messages').hide();
                if (data == 'success') {
                    $('#success').show();
                    $('#success p').text("Location type updated successfully.");
                } else if (data == 'Deleted Successfully') {
                    $('#success').show();
                    $('#success p').text("Location type deleted successfully.");
                } else if (data == 'error') {
                    $('#error').show();
                    $('#error p').text("This location type cannot be deleted as it has locations associated with it.");
                }
                $('html, body').animate({
                    scrollTop: $("#error").offset().top
                }, 1000);
            },
            restoreButton: false
        });
        @endif
        @endcan

    });

</script>