@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Jira Credentials','parentTitle'=>'Settings','parentUrl'=>'/settings'])
<div class="wrapper-content">
    <div class="container-fluid">
        
        <div class="ibox">
            
            <div class="ibox-content">
                
                <!-- <p><a href="#" class="btn btn-primary" data-toggle="modal" href="remote.html" data-target="#addApiCredential">Add New</a></p> -->
                @include('partials.error-message')
                
                @include('settings.partials.delete-message')
                
                <table class="footable table table-stripped table-hover" data-page-size="50" data-filter=#filter id="api-credential-table">

                    <thead>

                        <tr>
                            <th>#</th>
                            <th>Connect</th>
                            <th>Status</th>
                            <th>Name</th>
                            <th>URL</th>
                            <th></th>
                        </tr>

                    </thead>

                    <tbody>

                        @if($apiCredential)
                        <tr>
                            <td>1</td>
                            <td><a href="{{$status == 1 ? '#' : route('jira-credentials.connect')}}"
                                    class="btn btn-primary btn-sm" {{$status==1 ? 'disabled' : '' }}>Connect</a>
                            </td>
                            <td>@if ($status == 1)
                                <button class="btn btn-primary btn-sm" disabled="disabled">Active</button>
                                @else
                                <button class="btn btn-danger btn-sm" disabled="disabled">Inactive</button>
                                @endif
                            </td>
                            <td>{{$apiCredential->api_name}}</td>
                            <td>{{$apiCredential->url}}</td>
                            <td>@can('API Credentials Edit')
                                <a href="{{route('jira-credentials.edit', ['jira_credential' => $apiCredential->id])}}"><i class="icon icon-n-edit"></i></a>
                                @endcan
                            </td>
                        </tr>
                        @else
                        <tr>
                            <td colspan="6">No Api Credentials in the system.</td>
                        </tr>
                        @endif

                    </tbody>

                    <tfoot>

                        <tr>

                            <td colspan="6">

                                <ul class="pagination pull-right"></ul>

                            </td>

                        </tr>

                    </tfoot>

                </table>

                
                
            </div>
            
        </div>
        
    </div>
    
</div>


@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection


@section('after_scripts')
@include('settings.partials.responsive-fixedheader')
@stop