@extends('layouts.main')
@section('content')
@include('partials.breadcrumb', ['breadcrumbTitle' => 'Edit Jira Credential','parentTitle'=>'Settings','parentUrl'=>'/settings','parentSubTitle'=>'Jira','parentSubUrl'=>'/jira-credentials'])

<div class="wrapper-content">

	<div class="container-fluid">
		<div class="ibox">
			@include('partials.error')
			<div class="ibox-content">

				<form class="form-horizontal" method="post"
					action="{{route('jira-credentials.update', ['jira_credential' => $credential->id])}}">

					{{csrf_field()}}

					<input type="hidden" name="_method" value="PUT">


					<div class="form-group">
						<label class="col-lg-3 control-label">URL</label>
						<div class="col-lg-6">
							<input type="text" class="form-control" name="url" value="{{ old('url',$credential->url) }}">
						</div>
					</div>

					<div class="form-group">
						<label class="col-lg-3 control-label">Consumer Key</label>
						<div class="col-lg-6">
							<input type="password" class="form-control" name="consumer_key"
								value="">
							<span class="help-block m-b-none">To keep the old consumer key, leave this empty</span>
						</div>
					</div>

					<div class="form-group">
						<div class="col-lg-offset-3 col-lg-1">
							<button class="btn btn-primary" name="commit" type="submit">Save</button>
						</div>
						<div class="col-lg-2">
							@if ($status == 1)
							<button class="btn btn-primary" disabled="disabled">Active</button>
							@else
							<button class="btn btn-danger" disabled="disabled">Inactive</button>
							@endif
						</div>
					</div>

				</form>
				<div class="">
                    @if ($credential && file_exists(storage_path('keys/jira_publickey.pem')))
                    <p>Click on the icon to download the public key. <a href="{{ route('download-public-key', ['file' => 'jira_key']) }}"><i class="icon icon-box-arrow-down"></i></a></p>
                    @endif
                </div>
			</div>
		</div>
	</div>
</div>
@stop

@section('help-links')
@include('help.help-links',['helpLink'=>config('help-links.help_links.integrations'),'helpTitle'=>config('help-links.help_titles.integrations')])
@endsection


@section('after_scripts')
@include('assets.partials.scripts.common')
@stop
