@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['parentUrl' => '/settings','parentTitle' => 'Settings', 'breadcrumbTitle' => 'User Role Change History'])

<div class="wrapper-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                @include('settings.history.user-role-change-history.partials.filter')
                <div class="ibox">
                    <div class="ibox-content">
                        <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                        <a href="javascript:" id="export-csv" class="btn btn-primary pull-right" data-url="{{ route('user-role-change-history.export') }}" data-file-name="User Role Change History">Export to CSV</a>
                        <table class="footable table table-stripped table-hover nowrap three-col-fixed" data-role="ui-data-table" data-url="{{ route('user-role-change-history.data') }}" data-searching="false" data-ordering="false" data-page-size="50" data-fixed-header="true">
                            <thead>
                                <tr>
                                    <th data-col-name="id">#</th>
                                    <th data-col-name="user">User</th>
                                    <th data-col-name="changed_by">Changed By</th>
                                    <th data-col-name="from_role">From Role</th>
                                    <th data-col-name="to_role">To Role</th>
                                    <th data-col-name="date">Date</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('after_scripts')
@include('reports.scripts.common')
@include('reports.scripts.datatable')
<script>
$(document).ready(function () {
    $('#from_role, #to_role').on('change', function() {
        $('#search-form').submit();
    });
});
</script>
@stop