@extends('layouts.settings')
@section('content')
@include('partials.breadcrumb', ['parentUrl' => '/settings','parentTitle' => 'Settings', 'breadcrumbTitle' => 'User Login History'])

<div class="wrapper-content">
    <div class="container-fluid">
        @include('settings.history.user-login-history.partials.filter-user-login-history')
        <div class="ibox">
            <div class="ibox-content">
                <div class="ajax-loader"><img src="/img/ajax-loader-full-width.gif"></div>
                <a href="javascript:" id="export-csv" class="btn btn-primary pull-right" data-url="{{ route('user-login-history.export') }}" data-file-name="User Login History" >Export to CSV</a>
                <table class="footable table table-stripped table-hover nowrap three-col-fixed"  data-role="ui-data-table" data-url="{{ route('user-login-history.data') }}" data-searching="false" data-ordering="false" data-page-size="50" data-fixed-header="true">
                    <thead>
                        <th data-col-name="id">#</th>
                        <th data-col-name="name">Name</th>
                        <th data-col-name="email">Email</th>
                        <th data-col-name="title">Title</th>
                        <th data-col-name="location">Work Location</th>
                        <th data-col-name="system_role">System Role</th>
                        <th data-col-name="status">Employee Status</th>
                        <th data-col-name="date">Date</th>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>
@stop

@section('after_scripts')
@include('reports.scripts.common')
@include('reports.scripts.datatable')
@stop